<!doctype html>
<html lang="en">
<head>
    <script src="<?php echo e(asset('side_bar/js/search.js')); ?>"></script>
    <title>DRMS</title>
    <link rel="icon" href="<?php echo asset('uploads/logodemr.png'); ?>"/>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,800,900" rel="stylesheet">

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('side_bar/css/style.css')); ?>">

    <style>

    </style>
</head>
<body>



<div class="wrapper d-flex align-items-stretch " >
    <nav id="sidebar" class="active " style="position: sticky">
        <h1><a href="<?php echo e(url('/home/dash')); ?>" class="logo">DR.</a></h1>





            <?php if(auth()->user()->role !='Collector'): ?>
                <ul class="list-unstyled components mb-5">   <li>
                <a href="<?php echo e(route('viewUser')); ?>"><span class="fa fa-user"></span> User Management</a>
            </li>
            <li>
                <a href="<?php echo e(route('viewClient')); ?>"><span class="fa fa-handshake-o"></span> Client Management</a>
            </li>
            <li>
                <a href="<?php echo e(route('viewLeave')); ?>"><span class="fa fa-calendar-check-o"></span> Leaves</a>
            </li>
            <li>
                <a href="<?php echo e(route('viewStatus')); ?>"><span class="fa fa-strikethrough"></span> Status & Target Management</a>
            </li>

            <li>
                <a href="<?php echo e(route('viewBatch')); ?>"><span class="fa fa-file-excel-o"></span> Batch Management</a>
            </li>

            <li>
                <a href="<?php echo e(url('/contact/home')); ?>"><span class="fa fa-address-card"></span> Contact Management</a>
            </li>

            <li>
                <a href="<?php echo e(url('/payment')); ?>"><span class="fa fa-cc-visa" aria-hidden="true"></span> Payment Management</a>
            </li>
        </ul>
        <?php endif; ?>
        <div class="footer">
            <p>
                Copyright &copy;<script>document.write(new Date().getFullYear());</script> All rights reserved | This template is made with <i class="icon-heart" aria-hidden="true"></i> by <a href="https://colorlib.com" target="_blank">Colorlib.com</a>
            </p>
        </div>
    </nav>

    <!-- Page Content  -->
    <div id="content" class="p-4 p-md-5" >

        <nav class="navbar navbar-expand-lg navbar-light bg-light">
            <div class="container-fluid">

                <button type="button" id="sidebarCollapse" class="btn btn-primary">
                    <i class="fa fa-bars"></i>
                    <span class="sr-only">Toggle Menu</span>
                </button>
                <button class="btn btn-dark d-inline-block d-lg-none ml-auto" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <i class="fa fa-bars"></i>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="nav navbar-nav ml-auto">
                        <li class="nav-item active">
                            <a class="nav-link" href="<?php echo e(url('/home/dash')); ?>">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">About</a>
                        </li>



                        <li class="nav-item">
                        <li class="nav-item dropdown">
                            <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                <?php echo e(Auth::user()->name); ?>

                            </a>

                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                   onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                    <?php echo e(__('Logout')); ?>

                                </a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </li>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
        <?php if(session('error')): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo e(session('error')); ?>



            </div>

        <?php endif; ?>


        <?php if(session('success')): ?>
            <div class="alert alert-success" role="alert">
                <?php echo e(session('success')); ?>



            </div>

        <?php endif; ?>

        <?php if(session('warning')): ?>
            <div class="alert alert-warning" role="alert">
                <?php echo e(session('warning')); ?>



            </div>

        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?></div>

</div>



<script src="<?php echo e(asset('side_bar/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('side_bar/js/popper.js')); ?>"></script>
<script src="<?php echo e(asset('side_bar/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('side_bar/js/main.js')); ?>"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>

</body>
</html>
<?php /**PATH C:\xampp2022\htdocs\New\DRMS_\resources\views/layouts/side_bar.blade.php ENDPATH**/ ?>