<?php

use App\Http\Controllers\batch\assignmentManagement;
use App\Http\Controllers\batch\batchController;
use App\Http\Controllers\batch\batchDataImport;
use App\Http\Controllers\client\clientController;
use App\Http\Controllers\collector\collectorDashbord;
use App\Http\Controllers\contactManagement\contactManagement;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LeaveSetting\Leave;
use App\Http\Controllers\password\customPassword;
use App\Http\Controllers\paymentManagement\paymentController;
use App\Http\Controllers\statusCodeSetting\StatusCodeSettingController;

use App\Http\Controllers\tps\tpsSourceController;

use App\Http\Controllers\tps\tpsData;
use App\Http\Controllers\userManagement\userManagement;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});
Route::get('/t', function () {
    return view('trt');
});


Route::get('/tt', function () {
//    return view('welcome');
    dd(number_format('100000000'));
});


Route::get('/first_login_pass_reset', function () {
    return view('auth.passwords.first_login_pass_reset');
});
Route::post('/password_reset', [customPassword::class, 'password_reset'])->name('password_reset');
Auth::routes();


Route::group(['middleware'=>["changeDefaultPass"]],function(){
    Route::get('/home', [collectorDashbord::class, 'collectorHome'])->name('collectorHome');
    /*
|--------------------------------------------------------------------------
| User Management
|--------------------------------------------------------------------------

|
*/
    Route::get('/viewAllUser', [userManagement::class, 'viewUser'])->name('viewUser');
    Route::get('user/deactivate/{id}', [userManagement::class, 'deactivateUser'])->name('deactivateUser');
    Route::get('user/activate/{id}', [userManagement::class, 'activateUser'])->name('activateUser');
    Route::get('user/pass_reset/{id}', [userManagement::class, 'pass_reset'])->name('pass_reset');
    Route::get('user/edit/{id}', [userManagement::class, 'editUser'])->name('editUser');
    Route::post('user/update/{id}', [userManagement::class, 'updateUser'])->name('updateUser');



    /*
|--------------------------------------------------------------------------
| client Management
|--------------------------------------------------------------------------

|
*/
    Route::get('/add/client', function () {
        return view('clientManagement.addClient');
    });

    Route::post('/reg_newClient', [clientController::class, 'registerClient'])->name('registerClient');
    Route::get('/viewAllClient', [clientController::class, 'viewClient'])->name('viewClient');
    Route::get('client/deactivate/{id}', [clientController::class, 'deactivateClient'])->name('deactivateClient');
    Route::get('client/activate/{id}', [clientController::class, 'activateClient'])->name('activateClient');
    Route::get('client/edit/{id}', [clientController::class, 'editClient'])->name('editClient');
    Route::post('client/update/{id}', [clientController::class, 'updateClient'])->name('updateClient');



/*
|--------------------------------------------------------------------------
| Leave Management
|--------------------------------------------------------------------------

|
*/

    Route::get('/add/leave', function () {
        return view('leaveManagement.addLeave');
    });

    Route::post('/reg_newLeave', [leave::class, 'registerLeave'])->name('registerLeave');
    Route::get('/viewAllLeave', [leave::class, 'viewLeave'])->name('viewLeave');
    Route::get('leave/edit/{id}', [leave::class, 'editLeave'])->name('editLeave');
    Route::post('leave/update/{id}', [leave::class, 'updateLeave'])->name('updateLeave');
    Route::get('leave/delete/{id}', [leave::class, 'deleteLeave'])->name('deleteLeave');
    Route::post('newCollectorTarget', [leave::class, 'newCollectorTarget'])->name('newCollectorTarget');




    /*
|--------------------------------------------------------------------------
| status  Management
|--------------------------------------------------------------------------

|
*/

    Route::get('/add/status', function () {
        return view('statusCodeSetting.addStatusCode');
    });
    Route::post('/reg_newStatus', [StatusCodeSettingController::class, 'registerStatus'])->name('registerStatus');
    Route::get('/viewAllStatus', [StatusCodeSettingController::class, 'viewStatus'])->name('viewStatus');
    Route::get('status/edit/{id}', [StatusCodeSettingController::class, 'editStatus'])->name('editStatus');
    Route::post('status/update/{id}', [StatusCodeSettingController::class, 'updateStatus'])->name('updateStatus');
    Route::get('status/deactivate/{id}/{table}', [StatusCodeSettingController::class, 'deactivateStatus'])->name('deactivateStatus');
    Route::get('status/activate/{id}/{table}', [StatusCodeSettingController::class, 'activateStatus'])->name('activateStatus');

    Route::post('newTarget', [StatusCodeSettingController::class, 'newTarget'])->name('newTarget');
    Route::get('target/view/{id}', [StatusCodeSettingController::class, 'viewTarget'])->name('viewTarget');
    Route::post('target/edit/', [StatusCodeSettingController::class, 'editTarget'])->name('editTarget');
    Route::post('newCollectorTarget', [StatusCodeSettingController::class, 'newCollectorTarget'])->name('newCollectorTarget');
    Route::get('deleteCollectorTarget/{id}/{amount}/{cid}', [StatusCodeSettingController::class, 'deleteCollectorTarget'])->name('deleteCollectorTarget');
    Route::post('client/target/edit/', [StatusCodeSettingController::class, 'editClientTarget'])->name('editClientTarget');



    /*
|--------------------------------------------------------------------------
| batch  Management
|--------------------------------------------------------------------------

|
*/



    Route::get('/add/batch', [batchController::class, 'index'])->name('batchIndex');

    Route::post('/reg_newBatch', [batchController::class, 'registerBatch'])->name('registerBatch');
    Route::get('/viewAllBatch', [batchController::class, 'viewBatch'])->name('viewBatch');
    Route::get('batch/edit/{id}', [batchController::class, 'editBatch'])->name('editBatch');
    Route::post('batch/update/{id}', [batchController::class, 'updateBatch'])->name('updateBatch');
    Route::get('batch/deactivate/{id}', [batchController::class, 'deactivateBatch'])->name('deactivateBatch');
    Route::get('batch/activate/{id}', [batchController::class, 'activateBatch'])->name('activateBatch');




    /*
|--------------------------------------------------------------------------
| batch DAta Management
|--------------------------------------------------------------------------

|
*/



    Route::get('/upload/batch', function () {
        return view('batchDataManagement.uploadBatch');
    });


    Route::match(['get','post'],'/up', [batchDataImport::class, 'upload'])->name('ardup');
    Route::post('/im', [batchDataImport::class, 'im'])->name('ardim');
    Route::get('/dup/{batch}', [batchDataImport::class, 'handle_duplicate'])->name('handle_duplicate');
    Route::get('/dup_bulk/{batch}', [batchDataImport::class, 'dup_bulk'])->name('dup_bulk');
    Route::post('/dup/data/{batch}', [batchDataImport::class, 'update_duplicate'])->name('update_duplicate');
    Route::post('/dup_bulk/data/{batch}', [batchDataImport::class, 'update_duplicate_bulk'])->name('update_duplicate_bulk');
    Route::match(['get','post'],'/mapping', [batchDataImport::class, 'mapping'])->name('mapping');
    Route::get('/all/batch', [batchDataImport::class, 'allBatch'])->name('allBatch');

//    cancel button ->from import
    Route::get('/cancel-import/{file}/{from}', [batchDataImport::class, 'cancelButton'])->name('cancelButton');


    /*
|--------------------------------------------------------------------------
| batch DAta Management 2
|--------------------------------------------------------------------------

|
*/



    Route::get('/search/batch', [assignmentManagement::class, 'search_batch'])->name('search_batch');
    Route::match(['get','post'],'/searched/batch', [assignmentManagement::class, 'searched'])->name('searched');
    Route::post('/add/collector', [assignmentManagement::class, 'assignCollector'])->name('assignCollector');
    Route::get('/account/details/{ac}', [assignmentManagement::class, 'accountDetails'])->name('accountDetails');
    Route::get('/downloadAccount', [assignmentManagement::class, 'downloadAccount'])->name('downloadAccount');

    /*
|--------------------------------------------------------------------------
| contact Management 2 account details
|--------------------------------------------------------------------------

|
*/



    Route::post('note/update/{ac}/{batch}', [assignmentManagement::class, 'updateNote'])->name('updateNote');
    Route::post('note/add/{ac}/{batch}', [assignmentManagement::class, 'addNote'])->name('addNote');
    Route::post('actionStatus/update/{ac}/{batch}', [assignmentManagement::class, 'statusUpdate'])->name('statusUpdate');
    Route::post('accountStatus/update/{ac}/{batch}', [assignmentManagement::class, 'accountUpdate'])->name('accountUpdate');
    Route::post('new/payment/{ac}/{batch}', [assignmentManagement::class, 'newPayment'])->name('newPayment');
    Route::get('/account/change/{ac}/{go}', [assignmentManagement::class, 'accountChange'])->name('accountChange');





    /*
|--------------------------------------------------------------------------
| internal notes  details
|--------------------------------------------------------------------------

|
*/


    Route::get('/fetchNote/{ac}', [assignmentManagement::class, 'fetchNote'])->name('fetchNote');
    Route::post('/createOrUpdateNote', [assignmentManagement::class, 'createOrUpdateNote'])->name('createOrUpdateNote');
    Route::get('/deleteNote/{ac}', [assignmentManagement::class, 'deleteNote'])->name('deleteNote');
    Route::get('/backToAllBatch/{type}/{notification}', [assignmentManagement::class, 'backToAllBatch'])->name('backToAllBatch');

    /*
|--------------------------------------------------------------------------
| contact Management 2
|--------------------------------------------------------------------------

|
*/

    Route::get('/contact/home', function () {
        return view('contactManagement.contactHome');
    });

    Route::get('/contact/upload', function () {
        return view('contactManagement.contactUpload');
    });


    Route::post('/imContact', [contactManagement::class, 'imContact'])->name('imContact');
    Route::post('/storeContact', [contactManagement::class, 'storeContact'])->name('storeContact');
    Route::post('/contactSearch', [contactManagement::class, 'contactSearch'])->name('contactSearch');
    Route::get('/contactEdit/{id}', [contactManagement::class, 'contactEdit'])->name('contactEdit');
    Route::post('/contactUpdate/{id}', [contactManagement::class, 'contactUpdate'])->name('contactUpdate');
    Route::get('/contactDelete/{id}', [contactManagement::class, 'contactDelete'])->name('contactDelete');





    /*
 |--------------------------------------------------------------------------
  payment
 |--------------------------------------------------------------------------

 |
 */


    Route::get('/payment', [paymentController::class, 'paymentHome'])->name('paymentHome');
    Route::get('/payment_download', [paymentController::class, 'downloadPayment'])->name('downloadPayment');
    Route::get('/downloadPayment_summary/{type}', [paymentController::class, 'downloadPayment_summary'])->name('downloadPayment_summary');


    Route::post('/imPayment', [paymentController::class, 'imPayment'])->name('imPayment');

    Route::post('/storePayment', [paymentController::class, 'storePayment'])->name('storePayment');

    Route::post('/search_payment', [paymentController::class, 'search_payment'])->name('search_payment');


    Route::get('/paymentMethod', [paymentController::class, 'paymentMethod'])->name('paymentMethod');

    Route::post('/registerPaymentMethod', [paymentController::class, 'registerPaymentMethod'])->name('registerPaymentMethod');


        Route::get('/payMethod_delete/{id}', [paymentController::class, 'payMethod_delete'])->name('payMethod_delete');

    /*
 |--------------------------------------------------------------------------
  tps source
 |--------------------------------------------------------------------------

 |
 */

    Route::get('/tpsSource', [tpsSourceController::class, 'tpsSource'])->name('tpsSource');
    Route::post('/newTps', [tpsSourceController::class, 'newTps'])->name('newTps');
    Route::post('/newTpsUser', [tpsSourceController::class, 'newTpsUser'])->name('newTpsUser');
    Route::post('/editTpsSource', [tpsSourceController::class, 'editTpsSource'])->name('editTpsSource');
    Route::match(['get','post'],'/tpsData', [tpsData::class, 'tpsData'])->name('tpsData');
    Route::match(['get','post'],'/tpsData_sent', [tpsData::class, 'tpsData_sent'])->name('tpsData_sent');
    Route::match(['get','post'],'/tpsInternal', [\App\Http\Controllers\tps\tpsInternal::class, 'tpsInternal'])->name('tpsInternal');
    Route::match(['get','post'],'/tpsOutput', [\App\Http\Controllers\tps\tpsOutput::class, 'tpsOutput'])->name('tpsOutput');
    Route::match(['get','post'],'/updateTpsInternal', [\App\Http\Controllers\tps\tpsInternal::class, 'updateTpsInternal'])->name('updateTpsInternal');




    /*
 |--------------------------------------------------------------------------
  collector
 |--------------------------------------------------------------------------

 |
 */
    Route::get('/selectedColour/{id}', [HomeController::class, 'selectedColour'])->name('selectedColour');
    Route::match(['get','post'],'/target', [HomeController::class, 'target'])->name('target');
   // Route::get('related-colors', ['as' => 'related-colors', 'uses' => 'FrontController@selectedColour']);
//
//    Route::get('/collector/home', function () {
//        return view('collector.home.collectorHome');
//    });



    Route::get('/home/dash', [collectorDashbord::class, 'collectorHome'])->name('collectorHome');
    Route::get('/tryy', [collectorDashbord::class, 'tryy'])->name('tryy');
    Route::match(['get','post'],'/accountList', [collectorDashbord::class, 'accountList'])->name('accountList');
    Route::match(['get','post'],'/followupAssist', [collectorDashbord::class, 'followupAssist'])->name('followupAssist');
    Route::match(['get','post'],'/searchByStatus/{status}', [collectorDashbord::class, 'searchByStatus'])->name('searchByStatus');
});
