@extends('layouts.side_bar')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">{{ __('Edit User Info') }}</div>
                    <div class="card text-warning">Edit information for User Id : {{$user->login_name}}</div>

                    <div class="card-body">
                        <form method="POST" action="{{ url('user/update/'.$user->id) }}" enctype="multipart/form-data">
                            @csrf

                            <div class="form-group row">
                                <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('Name') }}</label>

                                <div class="col-md-6">
                                    <input id="name" type="text"
                                           class="form-control @error('name') is-invalid @enderror" name="name"
                                           value="{{$user->name}}" required autocomplete="name" autofocus>

                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                {{--                                <div class="col-md-6 ">--}}
                                {{--                                    <small>current name is :{{$user->name}} </small></div>--}}
                            </div>

                            {{--                            <div class="form-group row">--}}
                            {{--                                <label for="email" class="col-md-4 col-form-label text-md-right">{{ __('E-Mail Address') }}</label>--}}

                            {{--                                <div class="col-md-6">--}}
                            {{--                                    <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{$user->email}}" required autocomplete="email">--}}

                            {{--                                    @error('email')--}}
                            {{--                                    <span class="invalid-feedback" role="alert">--}}
                            {{--                                        <strong>{{ $message }}</strong>--}}
                            {{--                                    </span>--}}
                            {{--                                    @enderror--}}
                            {{--                                </div>--}}
                            {{--                                <small>current Email address :{{$user->email}} </small>--}}
                            {{--                            </div>--}}

                            <div class="form-group row">
                                <label for="email"
                                       class="col-md-4 col-form-label text-md-right">{{ __('Access Level') }}</label>

                                <div class="col-md-6">


                                    <select class="form-control" name="role" id="role" required>

                                        <option value="{{$user->role}}">{{$user->role}}</option>
                                        <option value="Superuser ">Superuser</option>
                                        <option value="Admin ">Admin</option>
                                        <option value="Manager ">Manager</option>
                                        <option value="Team_Leader">Team Leader</option>
                                        <option value="Collector">Collector</option>
                                        <option value="Field_Officer">Field Officer</option>

                                    </select>

                                    <small>current access level is :{{$user->role}} </small>
                                </div>
                            </div>

                            <?php

                            use Illuminate\Support\Facades\DB;

                            $manager = DB::table('users')->select('name')->where('role', 'manager')->where('status', 'Active')->get();
                            $team = DB::table('users')->select('name')->where('role', 'Team_Leader')->where('status', 'Active')->get();

                            ?>

{{--                            @if($user->manager !=null)--}}
                                <div class="form-group row" id="manager" >
                                    <label for="email"
                                           class="col-md-4 col-form-label text-md-right">{{ __('Manager') }}</label>

                                    <div class="col-md-6">


                                        <select class="form-control" name="manager" id="manager1" required>
                                            <option value="{{$user->manager}}">{{$user->manager}}</option>
                                            @foreach($manager as $m)
                                                <option value="{{$m->name}}">{{$m->name}} </option>
                                            @endforeach


                                        </select>
                                        <small>current Manager is :{{$user->manager}} </small>
                                    </div>
                                </div>

{{--                                @if($user->team !=null)--}}
                                    <div class="form-group row" id="team">
                                        <label for="email"
                                               class="col-md-4 col-form-label text-md-right">{{ __('Team leader') }}</label>

                                        <div class="col-md-6">


                                            <select class="form-control" name="team" id="team1" required>

                                                <option value="{{$user->team}}">{{$user->team }}</option>
                                                @foreach($team as $m)
                                                    <option value="{{$m->name}}">{{$m->name}} </option>
                                                @endforeach

                                            </select>
                                            <small>current Team leader is :{{$user->team}} </small>
                                        </div>
                                    </div>

{{--                                @endif--}}
{{--                            @endif--}}

                            <div class="form-group row mb-0">
                                <div class="col-md-6 offset-md-4">
                                    <button type="submit" class="btn btn-primary">
                                        {{ __('Save') }}
                                    </button>
                                    <a href="{{route('viewUser')}}" class="btn btn-danger">
                                        {{ __('Cancel') }}
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <script>
        $(document).ready(function () {
            var team = "<?php echo $user->team; ?>";

            if(team == null || team == ""){
                // alert(team)
                $('#team').hide();
                $('#team1').hide().removeAttr('required').val("");
            }

            var manager = "<?php echo $user->manager; ?>";
            // alert(manager)
            if(manager == null || manager == ""){
                $('#manager').hide();

                $('#manager1').hide().removeAttr('required').val("");
            }



        })


        $('#role').on('change', function (e) {
            // alert('66');

            var role = e.target.value;

            if (role === 'Collector') {
                // alert('com')
                $('#manager').show();
                $('#team').show();
                $('#manager1').show().prop('required', true);
                $('#team1').show().prop('required', true);
            } else if (role === 'Team_Leader') {
                $('#manager').show();
                $('#manager1').show().prop('required', true);

                $('#team1').removeAttr('required').val("");

                $('#team').hide();
            } else {
                $('#manager1').removeAttr('required').val("");
                $('#team1').removeAttr('required').val("");
                $('#manager').hide();
                $('#team').hide();
            }

        })


    </script>




@endsection

