
@extends('layouts.side_bar')

@section('content')


<div class="container" style="min-width: 100%">

    <div class="card shadow-lg overflow-auto" style="max-height:500px ">
        <div class="card-header shadow text-center text-white bg-dark">
            All Active TPS Source

            <a class="btn btn-danger fa fa-plus-square-o ml-lg-5" data-toggle="modal"
               data-target="#exampleModalLong">
                Add TPS Source
            </a>
        </div>
        <input class="form-control" id="myInput3" type="text" placeholder="Search..">

        <table class="table text-nowrap ">
            <thead>
            <tr class="w3-light-grey w3-hover-red">
                <th>SL</th>
                <th>TPS Name</th>
                <th>TPS Type</th>
                <th>TPS Code</th>
                <th>Status</th>

                <th>ACTION</th>


            </tr>
            </thead>
            <tbody id="myTable3">
            @foreach($tpsSource as $row)

                        <tr class="w3-hover-green">


                            <td>{{ $row->id}}</td>
                            <td>{{ $row->tpsName}}</td>
                            <td>{{ $row->tpsType }}</td>
                            <td>{{ $row->tpsCode}}</td>
                            <td>{{ $row->tpsStatus}}</td>

                            <td>
                                <a type="button" class="btn btn-warning text-white "
                                   data-toggle="modal"
                                   data-target=".bd-example-modal-lg_edit"
                                   onclick="targetEdit('{{$row->id}}','{{$row->tpsName}}','{{$row->tpsType}}','{{$row->tpsCode}}','{{$row->tpsStatus}}')">Edit
</a>

{{--                                <a href="{{ URL::to('target/view/'.$row->id) }}"--}}
{{--                                   class="btn btn-sm btn-info text-white">View</a>--}}

                            </td>
                        </tr>

                    @endforeach
            </tbody>
        </table>
    </div>
</div>













<!-- Modal -->
<div class="modal fade bd-example-modal-lg" id="exampleModalLong" tabindex="-1" role="dialog"
     aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Register New TPS Source </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{----}}
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-8">
                            <div class="card">


                                <div class="card-body">
                                    <form method="POST" action="{{ route('newTps') }}" id="myform">
                                        @csrf


                                        <div class="form-group row">
                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('TPS Name') }}</label>



                                            <div class="col-md-6">
                                                <input id="from" type="text" class="form-control" name="tpsName"
                                                       autocomplete="tpsName" required autofocus>


                                            </div>

                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('TPS Type') }}</label>


                                            <div class="col-md-6">

                                                <select name="tpsType" class="form-control">

                                                        <option value="LIVE">LIVE</option>
                                                        <option value="INTERNAL">INTERNAL</option>

                                                </select>
                                            </div>


                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('TPS Code') }}</label>

                                            <div class="col-md-6">
                                                <input id="from" type="text" class="form-control" name="tpsCode" @error('tpsCode') is-invalid @enderror"
                                                       autocomplete="name" required autofocus>
                                                @error('tpsCode')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror

                                            </div>







                                        </div>


                                        <div class="form-group row mb-0">
                                            <div class="col-md-6 offset-md-4">
                                                <button type="submit" class="btn btn-primary">
                                                    {{ __('Register') }}
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                {{----}}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            </div>
        </div>
    </div>
</div>
{{--  end modal  --}}





<!-- Modal -->
<div class="modal fade bd-example-modal-lg_edit" id="exampleModalLong" tabindex="-1" role="dialog"
     aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Edit Target</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{----}}
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-8">
                            <div class="card">


                                <div class="card-body">
                                    <form method="POST" action="{{ route('editTpsSource') }}" id="myformtarget">
                                        @csrf


                                        <label class="form-group row">
                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('TPS Name : ') }}</label>

                                            <div class="col-md-6">

                                                <input type="text" name="tpsName" id="targetName" class="form-control"
                                                       value="" >
                                            </div>

                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('TPS Type : ') }}</label>

                                            <div class="col-md-6">
                                                <label for="one" style="margin-top: 5%;">
                                                <input type="radio" name="tpsType" id="targetType_LIVE" class="custom-radio"
                                                       value="" >
                                                <label for="html" id="targetType_LIVE1">LIVE</label>
                                                <input type="radio" name="tpsType" class="custom-radio" id="targetType_int"
                                                       value="" >
                                                <label for="html"  id="targetType_int1">INTERNAL</label>

                                        </label>
                                </div>
                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('TPS Code : ') }}</label>

                                            <div class="col-md-6">

                                                <input type="text" name="tpsCode" id="targetCode" class="form-control"
                                                       value="" readonly>
                                            </div>

                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('Status : ') }}</label>

                                            <div class="col-md-6">

                                                <label for="one1" style="margin-top: 5%;">
                                                    <input type="radio" name="tpsStatus" id="targetType_ac" class="custom-radio"
                                                           value="" >
                                                    <label for="html" id="targetType_ac1">ACTIVE</label>
                                                    <input type="radio" name="tpsStatus" class="custom-radio" id="targetType_de"
                                                           value="" >
                                                    <label for="html"  id="targetType_de1">DEACTIVATE</label>

                                                </label>
                                            </div>



                                            {{--                                                    <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('Target Amount') }}</label>--}}

                                            <div class="col-md-6">
                                                <input type="hidden" class="form-control" id="targetID" name="id"
                                                       value="">


                                            </div>

                                        </div>



                                        <div class="form-group row mb-0">
                                            <div class="col-md-6 offset-md-4">
                                                <button type="submit" class="btn btn-primary"
                                                        onclick="return confirm('Are you sure to change the details ?')">
                                                    {{ __('Update') }}
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                {{----}}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            </div>
        </div>
    </div>

{{--  end modal  --}}


{{--tps assign --}}





<div class="container" style="min-width: 100%">

    <div class="card shadow-lg overflow-auto" style="max-height:500px ">
        <div class="card-header shadow text-center text-white bg-dark">
            All ASSIGN USER

            <a class="btn btn-danger fa fa-plus-square-o ml-lg-5" data-toggle="modal"
               data-target="#exampleModalLong_user">
                Add New User
            </a>
        </div>
        <input class="form-control" id="myInput3" type="text" placeholder="Search..">

        <table class="table text-nowrap ">
            <thead>
            <tr class="w3-light-grey w3-hover-red">
                <th>SL</th>
                <th>TPS Name</th>
                <th>role</th>
                <th>login_name</th>
                <th>Status</th>

                <th>ACTION</th>


            </tr>
            </thead>
            <tbody id="myTable3">
            @foreach($tpsUser as $row)

                <tr class="w3-hover-green">


                    <td>{{ $row->id}}</td>
                    <td>{{ $row->name}}</td>
                    <td>{{ $row->tpsRole }}</td>
                    <td>{{ $row->login_name}}</td>
                    <td>{{ $row->status}}</td>

{{--                    <td>--}}
{{--                        <a type="button" class="btn btn-warning text-white "--}}
{{--                           data-toggle="modal"--}}
{{--                           data-target=".bd-example-modal-lg_edit"--}}
{{--                           onclick="targetEdit('{{$row->id}}','{{$row->tpsName}}','{{$row->tpsType}}','{{$row->tpsCode}}','{{$row->tpsStatus}}')">Edit--}}
{{--                        </a>--}}

{{--                        <a href="{{ URL::to('target/view/'.$row->id) }}"--}}
{{--                           class="btn btn-sm btn-info text-white">View</a>--}}

{{--                    </td>--}}
                </tr>

            @endforeach
            </tbody>
        </table>
    </div>
</div>















<!-- Modal user -->
<div class="modal fade bd-example-modal-lg_user" id="exampleModalLong_user" tabindex="-1" role="dialog"
     aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Register New User </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{----}}
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-8">
                            <div class="card">


                                <div class="card-body">
                                    <form method="POST" action="{{ route('newTpsUser') }}" id="myform">
                                        @csrf


                                        <div class="form-group row">


                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('User') }}</label>


                                            <div class="col-md-6">

                                                <select name="name" class="form-control">
                                                    @foreach($User as $u)
                                                    <option value={{$u->id}}>{{$u->name}}</option>
{{--                                                    <option value="INTERNAL">INTERNAL</option>--}}

                                                    @endforeach                                  </select>
                                            </div>




                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('Access Lavel') }}</label>


                                            <div class="col-md-6">

                                                <select name="level" class="form-control">

                                                    <option value="1">1</option>
                                                    <option value="2">2</option>
                                                    <option value="3">3</option>
                                                </select>
                                            </div>








                                        </div>


                                        <div class="form-group row mb-0">
                                            <div class="col-md-6 offset-md-4">
                                                <button type="submit" class="btn btn-primary">
                                                    {{ __('Assign') }}
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                {{----}}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            </div>
        </div>
    </div>
</div>
{{--  end modal  --}}





<!-- Modal user-->
<div class="modal fade bd-example-modal-lg_edit_user" id="exampleModalLong" tabindex="-1" role="dialog"
     aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Edit Target</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{----}}
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-8">
                            <div class="card">


                                <div class="card-body">
                                    <form method="POST" action="{{ route('editTpsSource') }}" id="myformtarget">
                                        @csrf


                                        <label class="form-group row">
                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('TPS Name : ') }}</label>

                                            <div class="col-md-6">

                                                <input type="text" name="tpsName" id="targetName" class="form-control"
                                                       value="" >
                                            </div>

                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('TPS Type : ') }}</label>

                                            <div class="col-md-6">
                                                <label for="one" style="margin-top: 5%;">
                                                    <input type="radio" name="tpsType" id="targetType_LIVE" class="custom-radio"
                                                           value="" >
                                                    <label for="html" id="targetType_LIVE1">LIVE</label>
                                                    <input type="radio" name="tpsType" class="custom-radio" id="targetType_int"
                                                           value="" >
                                                    <label for="html"  id="targetType_int1">INTERNAL</label>

                                                </label>
                                            </div>
                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('TPS Code : ') }}</label>

                                            <div class="col-md-6">

                                                <input type="text" name="tpsCode" id="targetCode" class="form-control"
                                                       value="" readonly>
                                            </div>

                                            <label for="name"
                                                   class="col-md-4 col-form-label text-md-right">{{ __('Status : ') }}</label>

                                            <div class="col-md-6">

                                                <label for="one1" style="margin-top: 5%;">
                                                    <input type="radio" name="tpsStatus" id="targetType_ac" class="custom-radio"
                                                           value="" >
                                                    <label for="html" id="targetType_ac1">ACTIVE</label>
                                                    <input type="radio" name="tpsStatus" class="custom-radio" id="targetType_de"
                                                           value="" >
                                                    <label for="html"  id="targetType_de1">DEACTIVATE</label>

                                                </label>
                                            </div>



                                            {{--                                                    <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('Target Amount') }}</label>--}}

                                            <div class="col-md-6">
                                                <input type="hidden" class="form-control" id="targetID" name="id"
                                                       value="">


                                            </div>

                                </div>



                                <div class="form-group row mb-0">
                                    <div class="col-md-6 offset-md-4">
                                        <button type="submit" class="btn btn-primary"
                                                onclick="return confirm('Are you sure to change the details ?')">
                                            {{ __('Update') }}
                                        </button>
                                    </div>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            {{----}}
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

        </div>
    </div>
</div>
</div>




</div>

{{--tps//--}}
<script>
    //to keep focus on current active tab
    $(document).ready(function () {
        $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {
            localStorage.setItem('activeTab', $(e.target).attr('href'));
        });
        var activeTab = localStorage.getItem('activeTab');
        if (activeTab) {
            $('#myTab a[href="' + activeTab + '"]').tab('show');
        }
    });
</script>






<script>

    $('#myform').submit(function () {

        var from = $("#from").val();
        var to = $("#to").val();

        if (Date.parse(from) >= Date.parse(to)) {
            alert("Invalid Date Range");
            return false;
        } else {
            //  alert("Valid date Range"+from+ 'to' +to);
            return true;
        }


        // return true; // return false to cancel form action
    });


</script>



<script>

    $('#myformtarget').submit(function () {

        var from = $("#fromf").val();
        var to = $("#tof").val();

        if (Date.parse(from) >= Date.parse(to)) {
            alert("Invalid Date Range");
            return false;
        } else {
            //  alert("Valid date Range"+from+ 'to' +to);
            return true;
        }


        // return true; // return false to cancel form action
    });


</script>



{{--        --}}
{{--</div>--}}







<script>
    function targetEdit(id,tpsName,tpsType,tpsCode,tpsStatus) {


        document.getElementById("targetName").value = tpsName;

        document.getElementById("targetCode").value = tpsCode;
        if(tpsType==='LIVE'){

            document.getElementById("targetType_LIVE").value = tpsType;
            document.getElementById("targetType_LIVE").checked = true;

        }
        else {
            document.getElementById("targetType_int").value = tpsType;
            document.getElementById("targetType_int").checked = true;
        }

        if(tpsStatus==='active'){

            document.getElementById("targetType_ac").value = tpsStatus;
            document.getElementById("targetType_ac").checked = true;

        }
        else {
            document.getElementById("targetType_de").value = tpsStatus;
            document.getElementById("targetType_de").checked = true;
        }

        document.getElementById("targetID").value = id;


    }


</script>


<script>
    $(document).ready(function () {
        $("#myInput").on("keyup", function () {
            var value = $(this).val().toLowerCase();
            $("#myTable tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
    });
</script>
<script>
    $(document).ready(function () {
        $("#myInput1").on("keyup", function () {
            var value = $(this).val().toLowerCase();
            $("#myTable1 tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
    });
</script>

<script>
    $(document).ready(function () {
        $("#myInput2").on("keyup", function () {
            var value = $(this).val().toLowerCase();
            $("#myTable2 tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
    });
</script>
<script>
    $(document).ready(function () {
        $("#myInput3").on("keyup", function () {
            var value = $(this).val().toLowerCase();
            $("#myTable3 tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
    });
</script>


@endsection
