@extends('layouts.side_bar')

@section('content')

    <div class="card">
        <div class="card-header bg-dark font-weight-bold text-white">Target Details

        <a href="{{url('/viewAllStatus')}}" class="btn btn-danger float-right">Back</a>

        </div>
        <div class="card-body font-weight-bold text-dark">
            {{--    <label>Client Name : {{$clientTarget->client}}</label><br>--}}
            {{--    <label>Cycle From : {{$clientTarget->cycleFrom}}</label><br>--}}
            {{--    <label>Cycle To : {{$clientTarget->cycleTo}}</label><br>--}}
            {{--    <label>Total Target : {{$clientTarget->totalTarget}}</label><br>--}}
            {{--    <label>Status : {{$clientTarget->status}}</label><br>--}}


            <table class="table-responsive  flex-fill text-nowrap">
                <tr>
                    <td>
                        Client Name :
                    </td>
                    <td>
                        {{$clientTarget->client}}
                    </td>

                </tr>

                <tr>
                    <td>
                        Cycle From :
                    </td>
                    <td>
                        {{$clientTarget->cycleFrom}}
                    </td>

                </tr>

                <tr>
                    <td>
                        Cycle To :
                    </td>
                    <td>
                        {{$clientTarget->cycleTo}}
                    </td>

                </tr>

                <tr>
                    <td>
                        Total Target :
                    </td>
                    <td>
                        RM {{$clientTarget->totalTarget}}
                    </td>

                </tr>


                <tr>
                    <td>
                        Status :
                    </td>
                    <td>
                        {{$clientTarget->status}}
                    </td>

                </tr>

            </table>

        </div>

    </div>

    <div class="card text-center">
        <div class="card-header bg-warning font-weight-bold text-white">Collector Details
            @if( $freeToSign != null)
                <a type="button" class="fa fa-plus-square-o ml-lg-5 text-dark btn btn-info text-white"
                   data-toggle="modal" data-target="#exampleModalLong">Add New Collector</a>
            @endif
        </div>

        <div class="card-body">

            @if( $target_collector == '[]')
                <span class="bg-danger text-white font-weight-bold rounded p-2"> No Collector is assigned for this client</span>
            @else

                {{--/////////////////////////////////////////////////////////////////////////////////////////////////////////////////--}}
                <div class="w3-container">

                    <div class="card shadow-lg overflow-auto">
                        <h5 class="card shadow text-center text-white bg-primary">
                            All Active Target
                        </h5>
                        <input class="form-control" id="myInput1" type="text" placeholder="Search..">

                        <table class="table ">
                            <thead>
                            <tr class="w3-light-grey w3-hover-red">
                                <th>SL</th>
                                <th>Collector</th>
                                <th>Target</th>

                                <th>ACTION</th>


                            </tr>
                            </thead>
                            <tbody id="myTable1">
                            @foreach($target_collector as $row)

                                <tr class="w3-hover-green">
                                    <td>{{ $row->id}}</td>
                                    <td>{{ $row->collector}}</td>
                                    <td>{{ $row->target}}</td>

                                    <td>
                                        <a href="{{ URL::to('deleteCollectorTarget/'.$row->id.'/'.$row->target.'/'.$clientTarget->id) }}"
                                           class="btn btn-sm btn-danger"
                                           onclick="return confirm('Are you sure  ?')"
                                        >Delete</a>


                                        <a type="button" class="btn btn-warning text-white " data-toggle="modal"
                                           data-target=".bd-example-modal-lg-call"
                                           onclick="call('{{$row->collector}}','{{$row->target}}','{{$row->id}}')">Edit</a>
                                        {{--                                       <a href="{{ URL::to('target/edit/'.$row->id) }}" class="btn btn-sm btn-warning text-white">Edit</a>--}}

                                    </td>
                                </tr>

                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>



            @endif


        </div>
    </div>



    {{--edit modal--}}
    <div class="modal fade bd-example-modal-lg-call" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content text-dark font-weight-bold">

                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Edit Target</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {{----}}
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-md-8">
                                <div class="card">


                                    <div class="card-body">
                                        <form method="POST" action="{{ route('editTarget') }}" id="myform">
                                            @csrf


                                            <div class="form-group row">
                                                <label for="name"
                                                       class="col-md-4 col-form-label text-md-right">{{ __('Client Name') }}</label>

                                                <div class="col-md-6">
                                                    <input type="text" name="collector" id="collector" readonly>
                                                </div>


                                                <label for="name"
                                                       class="col-md-4 col-form-label text-md-right">{{ __('Target Amount') }}</label>

                                                <div class="col-md-6">
                                                    <input type="text" class="form-control" name="target" id="targeta"
                                                           required autofocus>

                                                    <input type="hidden" name="clientId" value="{{$clientTarget->id}}">
                                                    <input type="hidden" name="id" id="ids">
                                                    <input type="hidden" name="old" id="old">
                                                </div>

                                            </div>


                                            <div class="form-group row mb-0">
                                                <div class="col-md-6 offset-md-4">
                                                    <button type="submit" class="btn btn-primary">
                                                        {{ __('Update') }}
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    {{----}}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>
    {{--end edit--}}

















    <!-- Modal -->
    <div class="modal fade bd-example-modal-lg" id="exampleModalLong" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalLongTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Register New Target</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {{----}}
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-md-8">
                                <div class="card">


                                    <div class="card-body">
                                        <form method="POST" action="{{ route('newCollectorTarget') }}" id="myform">
                                            @csrf


                                            <div class="form-group row">
                                                <label for="name"
                                                       class="col-md-4 col-form-label text-md-right">{{ __('Collector Name') }}</label>

                                                <div class="col-md-6">
                                                    <select name="collector" class="form-control">
                                                        @foreach($freeToSign as $c)
                                                            <option value="{{$c}}">{{$c}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>


                                                <label for="name"
                                                       class="col-md-4 col-form-label text-md-right">{{ __('Target Amount') }}</label>

                                                <div class="col-md-6">
                                                    <input type="text" class="form-control" name="target" required
                                                           autofocus>

                                                    <input type="hidden" name="clientId" value="{{$clientTarget->id}}">
                                                </div>

                                            </div>


                                            <div class="form-group row mb-0">
                                                <div class="col-md-6 offset-md-4">
                                                    <button type="submit" class="btn btn-primary">
                                                        {{ __('Register') }}
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    {{----}}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>
    {{--  end modal  --}}


    <script>
        function call(collector, ammount, id) {


            document.getElementById("collector").value = collector;
            document.getElementById("targeta").value = ammount;
            document.getElementById("ids").value = id;
            document.getElementById("old").value = ammount;


        }


    </script>


@endsection
