@extends('layouts.side_bar')

@section('content')

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">{{ __('Register Status Code ') }}</div>

                    <div class="card-body">
                        <form method="POST" action="{{ route('registerStatus') }}">
                            @csrf

                            <div class="form-group row">
                                <label for="name"
                                       class="col-md-4 col-form-label text-md-right">{{ __('Remark Code') }}</label>

                                <div class="col-md-6">
                                    <input id="remark_code" type="text"
                                           class="form-control @error('remark_code') is-invalid @enderror"
                                           name="remark_code"
                                           value="{{ old('name') }}" required autocomplete="name" autofocus>

                                    @error('remark_code')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="name"
                                       class="col-md-4 col-form-label text-md-right">{{ __('Description') }}</label>

                                <div class="col-md-6">
                                    <input id="name" type="text"
                                           class="form-control @error('name') is-invalid @enderror" name="description"
                                           required autofocus>

                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="email"
                                       class="col-md-4 col-form-label text-md-right">{{ __('Type') }}</label>

                                <div class="col-md-6">


                                    <select class="form-control" name="type" id="status">

                                        <option value="Action_Status">Action Status</option>
                                        <option value="Account_Status">Account Status</option>


                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="email"
                                       class="col-md-4 col-form-label text-md-right">{{ __('Access Level') }}</label>

                                <div class="col-md-6">


                                    <select class="form-control" name="role">

                                        <option value="1">Level 1 (only superuser)</option>
                                        <option value="2">Level 2 (only superuser and admin)</option>
                                        <option value="3">Level 3 (All users)</option>


                                    </select>
                                </div>
                            </div>


                            <div class="form-group row" id="c">
                                <label for="email"
                                       class="col-md-4 col-form-label text-md-right">{{ __('Status Color') }}</label>

                                <div class="col-md-6">


                                    <select style="background-color: white" class="form-control" name="color" id="color"
                                            @error('color') is-invalid @enderror">
                                    <option value="">Null</option>

                                    <option value="red" style="background-color: red">red</option>
                                    <option value="rebeccapurple" style="background-color: rebeccapurple">
                                        rebeccapurple
                                    </option>

                                    <option value="lightgreen" style="background-color: lightgreen">lightgreen</option>
                                    <option value="greenyellow" style="background-color: greenyellow">greenyellow
                                    </option>
                                    <option value="green" style="background-color: green">green</option>

                                    <option value="lightblue" style="background-color: lightblue">lightblue</option>
                                    <option value="blue" style="background-color: blue">blue</option>
                                    <option value="deepskyblue" style="background-color: deepskyblue">deepskyblue
                                    </option>


                                    <option value="yellow" style="background-color: yellow">yellow</option>
                                    <option value="lightyellow" style="background-color: lightyellow">lightyellow</option>


                                    <option value="orange" style="background-color: orange">orange</option>
                                    <option value="orangered" style="background-color: orangered">orangered</option>
                                    <option value="lightpink" style="background-color: lightpink">lightpink</option>
                                    <option value="pink" style="background-color: pink">pink</option>
                                    <option value="magenta" style="background-color: magenta">magenta</option>


                                    <option value="peru" style="background-color: peru">peru</option>
                                    <option value="lightgray" style="background-color: lightgray">lightgray</option>
                                    <option value="gray" style="background-color: gray">gray</option>


                                    </select>
                                </div>
                            </div>
                            @error('color')
                            <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                            @enderror

                            <div class="form-group row mb-0">
                                <div class="col-md-6 offset-md-4">
                                    <button type="submit" class="btn btn-primary">
                                        {{ __('Save') }}
                                    </button>
                                    <a href="{{route('viewStatus')}}" class="btn btn-danger">
                                        {{ __('Cancel') }}
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <script>
        $(document).ready(function () {
            $('#c').hide();


        })


        $('#status').on('change', function (e) {
            // alert('66');

            const role = e.target.value;
//alert(typeof (role))
            if (role === "Account_Status") {
                // alert(role)
                $('#c').show();
            } else {
                $('#c').hide();
            }

        })


    </script>
    <script>
        $('#color').on('change', function (e) {

            document.getElementById("color").style.backgroundColor = document.getElementById("color").value;
        })


    </script>


@endsection






