
@extends('layouts.side_bar')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">{{ __('Update Batch Info ') }}</div>

                    <div class="card-body">
                        <form method="POST" action="{{ url('batch/update/'.$batch->id) }}" enctype="multipart/form-data">
                            @csrf




                            <div class="form-group row">
                                <label for="email" class="col-md-4 col-form-label text-md-right">{{ __('Client Name :') }}</label>

                                <label for="email" class="col-md-4 col-form-label text-md-right">{{$batch->client_name}}</label>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('Batch Name :') }}</label>

                                <label for="email" class="col-md-4 col-form-label text-md-right">{{$batch->batch_name}}</label>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('Assign Date :') }}</label>

                                <div class="col-md-6">
                                    <input id="assign_date" type="date" class="form-control @error('assign_date') is-invalid @enderror" name="assign_date" value="{{$batch->assign_date}}"  required autocomplete="assign_date" autofocus>

                                    @error('assign_date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('Valid Till :') }}</label>

                                <div class="col-md-6">
                                    <input id="valid_till" type="date" class="form-control @error('valid_till') is-invalid @enderror" name="valid_till" required autocomplete="valid_till" value="{{$batch->valid_till}}" autofocus>

                                    @error('valid_till')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>




                            <div class="form-group row mb-0">
                                <div class="col-md-6 offset-md-4">
                                    <button type="submit" class="btn btn-primary ">
                                        {{ __('Update') }}
                                    </button>

                                <a href="{{route('viewBatch')}}" class="btn btn-danger">
                                    {{ __('Cancel') }}
                                </a>
                            </div></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
