<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTpsSourcesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tps_sources', function (Blueprint $table) {
            $table->id();

            $table->string('tpsName');
            $table->string('tpsType');
            $table->string('tpsCode');
            $table->date('tpsStatus')->default('active');
            $table->float('assignment')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tps_sources');
    }
}
