<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientTargetsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_targets', function (Blueprint $table) {
            $table->id();
            $table->string('client');
            $table->string('status')->default('active');
            $table->date('cycleFrom');
            $table->date('cycleTo');
            $table->string('totalTarget');
            $table->string('collectPreWeek')->nullable();
            $table->string('collectToday')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_targets');
    }
}
