<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConfirmPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('confirm_payments', function (Blueprint $table) {
            $table->id();
            $table->string('accountNumber');
            $table->string('dataEnteredBy');
            $table->string('paidBy');
            $table->date('paidDate');
            $table->float('paidAmount');
            $table->string('paymentType');
            $table->string('status')->default('active');
            $table->integer('uid');
            $table->string('collector')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('confirm_payments');
    }
}
