<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCollectorPaymentLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('collector_payment_logs', function (Blueprint $table) {
            $table->id();
            $table->string('accountNumber');
            $table->string('collector');
            $table->string('paidByName');
            $table->string('paidByNric')->nullable();

            $table->date('paidDate');

            $table->float('paidAmount');
            $table->string('paymentType');

            $table->string('batch')->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('collector_payment_logs');
    }
}
