<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCollectorLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('collector_logs', function (Blueprint $table) {
            $table->id();
            $table->string('accountNumber');

            $table->string('by');
            $table->string('collector');
            $table->dateTime('from')->useCurrent();

            $table->dateTime('to')->nullable();
            $table->string('status')->default('active');



            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('collector_logs');
    }
}
