<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStatusLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('status_logs', function (Blueprint $table) {
            $table->id();
            $table->string('accountNumber');
            $table->string('now')->default('active');
            $table->string('by');
            $table->string('to')->nullable();
            $table->string('tel')->nullable();
            $table->string('status');
            $table->dateTime('nextCall')->nullable();

            $table->string('remark')->nullable();
            $table->date('ptpDate')->nullable();
            $table->string('ptpAmount')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('status_logs');
    }
}
