<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStatusCodeSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('status_code_settings', function (Blueprint $table) {
            $table->id();
            $table->string('remark_code');
            $table->string('description');
            $table->string('type');
            $table->string('role');
            $table->string('color')->nullable();
            $table->string('status')->default("Active");
            $table->unique(['remark_code', 'type']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('status_code_settings');
    }
}
