<?php

namespace App\Imports;

use App\Models\confirmPayment;
use App\Rules\checkAccount;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class paymentImport implements ToModel, WithBatchInserts,WithChunkReading,WithHeadingRow
    //,SkipsOnError
    // ,WithValidation
    ,SkipsOnFailure
    ,WithValidation
{
    use
        //SkipsErrors,
        Importable,SkipsFailures;


    public $accountNumber;
    public $paidBy;
    public $paidDate;
    public $paidAmount;
    public $paymentType;
    public $uid;
    public $Ref_type;



    function set_name($accountNumber,$paidAmount,$paidBy,$paidDate,$paymentType,$uid,$Ref_type){
        $this->accountNumber=$accountNumber;
        $this->paidAmount=$paidAmount;
        $this->paidBy=$paidBy;
        $this->paidDate=$paidDate;
        $this->paymentType=$paymentType;
        $this->uid=$uid;
        $this->Ref_type=$Ref_type;


        $old=DB::table('batch_datas')->where('status','!=','ABORT')->pluck($Ref_type)->toArray();
        session()->put('accountCheck',$old);

    }


    public function transformDate($value, $format = 'Y-m-d')
    {
        try {
            return \Carbon\Carbon::instance(\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($value));
        } catch (\ErrorException $e) {
            return \Carbon\Carbon::createFromFormat($format, $value);
        }
    }


    public function model(array $row)
    {

        //dd($newformat);
       // $da=$this->paidDate;
        $a_info = array();
        if($this->accountNumber!='xx'){
            if($this->Ref_type=='AccountNo'){
                $a_info['accountNumber'] = $row[$this->accountNumber];
            }else{
                $a_info[$this->Ref_type] = $row[$this->accountNumber];
            }
            }

        if($this->paidAmount!='xx')
            $a_info['paidAmount'] = $row[$this->paidAmount];

        if($this->paidBy!='xx')
            $a_info['paidBy'] = $row[$this->paidBy];
            //$a_info['paidBy'] = $row[$this->paidBy];

        if($this->paidDate!='xx'){

//            ($date,"Y/m/d H:i:s")
           $newformat  = date_format(Date::excelToDateTimeObject($row[$this->paidDate]),'Y-m-d');
//           dd($newformat);
            $a_info['paidDate'] =$newformat ;
        }


        if($this->paymentType!='xx')
            $a_info['paymentType'] = $row[$this->paymentType];

        $a_info['dataEnteredBy'] = auth()->user()->name;
        $a_info['uid'] = $this->uid;


        return new confirmPayment(

            $a_info



        );
    }














    public function chunkSize(): int
    {
        return 5000;
    }

    public function batchSize(): int
    {
        return 500;
    }

//    public function onError(\Throwable $e)
//    {
//
//    }

    public function rules(): array
    {
        return[
            $this->accountNumber=>new checkAccount()
        ];
    }





}
