<?php

namespace App\Http\Controllers\userManagement;


use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class userManagement extends Controller
{
    public function viewUser()
    {
        $user=DB::table('users')
            ->get();

        return view('userManagement.viewAllUser', array('user' => Auth::user()) )->with('user',$user);
    }


///////////////////////////////////////////////////////////////////////////


    public function deactivateUser($id)
    {
        $status = "Inactive";


        $affected = DB::table('users')
            ->where('id', $id)
            ->update(['status' => $status]);
        session()->flash('warning', 'user Deactivated !');
        return redirect()->route('viewUser');

    }
///////////////////////////////////////////////////////////



    public function activateUser($id)
    {
        $status = "Active";


        $affected = DB::table('users')
            ->where('id', $id)
            ->update(['status' => $status]);
        session()->flash('success', 'users Activated !');
        return redirect()->route('viewUser');

    }

/////////////////////////////////////////////////////////////////////////

public function pass_reset($id)
{

    $n_pass_h=Hash::make('ADR123');

    $pass_re = DB::table('users')->where('id', $id)
        ->update(['password' => $n_pass_h]);

    session()->flash('success', 'pass_reset successful !');
    return redirect()->route('viewUser');
}
//////////////////////////////////////////////////////////////

public function editUser($id){

    $user=DB::table('users')->where('id',$id)
        ->first();
//    dd($user);
    return view('userManagement.editUser', array('user' => Auth::user()) )->with('user',$user);
}

////////////////////////////////////////////////////////////
    public function updateUser(Request $req,$id)
    {
        $a_info = array();

        $a_info["name"] = $req->name;
//        $a_info["email"] = $req->email;
        $a_info["role"] = $req->role;
        $a_info["manager"] = $req->manager;
        $a_info["team"] = $req->team;


        $submit = DB::table('users')->where('id',$id)->update($a_info);
//        echo "<script>";
//        echo "alert('details updated');";
//        echo "</script>";
        session()->flash('error', 'details updated !');
        return redirect()->route('viewUser')->withInput();
    }


/////////////////////////////////////////////////////////////////



}
