<?php

namespace App\Http\Controllers\statusCodeSetting;

use App\Http\Controllers\Controller;
use App\Models\statusCodeSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Validation\ValidationException;

class StatusCodeSettingController extends Controller
{
    protected function registerStatus(Request $req)
    {
        $this->validate($req, [

//            'remark_code' => 'required|unique:status_code_settings',
            'remark_code' => 'required|unique:status_code_settings,remark_code,type'

        ]);

        $a_info = array();

        $a_info["remark_code"] = $req->remark_code;
        $a_info["description"] = $req->description;
        $a_info["type"] = $req->type;
        $a_info["role"] = $req->role;
        $a_info["color"] = $req->color;


        $submit = DB::table('status_code_settings')->insert($a_info);
        session()->flash('success', 'New remark code added successfully !');
        return redirect()->route('viewStatus');
    }


///////////////////////////////////////////////////////////////////////////////////
    public function viewStatus()
    {
        $status = DB::table('status_code_settings')
            ->get();
        $client_target = DB::table('client_targets')->get();
        $client_name = DB::table('clients')->select('name',)
            ->where('status', 'Active')
            ->
            get();

        $clientName=$client_name->pluck('name')->toArray();

        $addedClient=$client_target->pluck('client')->toArray();
        $client_name=array_diff($clientName, $addedClient);//get who is not assigned
        //dd($client_target);




        return view('statusCodeSetting.viewAllStatus', array('user' => Auth::user()))->with('status', $status)->with('client', $client_name)->with('client_target', $client_target);
    }


///////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////

    public function editStatus($id)
    {

        $status = DB::table('status_code_settings')->where('id', $id)
            ->first();
        return view('statusCodeSetting.editStatus', array('user' => Auth::user()))->with('status', $status);
    }

////////////////////////////////////////////////////////////


    public function updateStatus(Request $req, $id)
    {
//        $this->validate($req,[
//
//        'remark_code' => 'required|unique:status_code_settings',
//
//
//    ]);

        $a_info = array();

        $a_info["remark_code"] = $req->remark_code;
        $a_info["description"] = $req->description;
        $a_info["type"] = $req->type;
        $a_info["role"] = $req->role;
       // dd($a_info["type"]);
        if($a_info["type"]!='Action_Status'){
            $a_info["color"] = $req->color;
        }

        else{
            $a_info["color"] = null;
        }


        $submit = DB::table('status_code_settings')->where('id', $id)->update($a_info);

        session()->flash('success', 'details updated !');
        return redirect()->route('viewStatus')->withInput();
    }

///////////////////////////////////////////////////////////////////////////


    public function deactivateStatus($id, $table)
    {
        $status = "Inactive";
//dd($table);

        $affected = DB::table($table)
            ->where('id', $id)
            ->update(['status' => $status]);
        session()->flash('warning', 'Data Deactivated !');
        return redirect()->route('viewStatus');

    }

///////////////////////////////////////////////////////////


    public function activateStatus($id, $table)
    {
        $status = "Active";


        $affected = DB::table($table)
            ->where('id', $id)
            ->update(['status' => $status]);
        session()->flash('success', 'Data Activated !');
        return redirect()->route('viewStatus');

    }

/////////////////////////////////////////////////////////////////////////
///
///
    public function newTarget(Request $req)
    {

        try {
            $this->validate($req, [
                'cycleFrom' => 'required|date',
                'cycleTo' => 'date|after_or_equal:cycleFrom',

            ]);
        } catch (ValidationException $e) {

//            session()->flash('error', 'something went wrong !');
        }
        $data = array();
        $data['client'] = $req->client;
        $data['cycleFrom'] = $req->from;
        $data['cycleTo'] = $req->to;
        $data['totalTarget'] = $req->target;
//dd($data);
        $in = DB::table('client_targets')->insert($data);
        session()->flash('success', 'New client Target added successfully !');
        return redirect()->route('viewStatus');

    }


    /////////////
    public function editClientTarget(Request $req)
    {

        try {
            $this->validate($req, [
                'cycleFrom' => 'required|date',
                'cycleTo' => 'date|after_or_equal:cycleFrom',

            ]);
        } catch (ValidationException $e) {

//            session()->flash('error', 'something went wrong !');
        }
        $id=$req->id;
        $data = array();
        $data['client'] = $req->client;
        $data['cycleFrom'] = $req->from;
        $data['cycleTo'] = $req->to;
       // $data['i'] = $req->target;
//dd($data);
        $in = DB::table('client_targets')->where('id',$id)->update($data);
        session()->flash('success', 'New client Target updated successfully !');
        return redirect()->route('viewStatus');

    }





    public function newCollectorTarget(Request $req)
    {
        $data = array();
        $data['collector'] = $req->collector;
        $data['clientTargetId'] = $req->clientId;

        $data['target'] = $req->target;

        $in = DB::table('collector_targets')->insert($data);
        $target_update = DB::table('client_targets')->select('totalTarget')
            ->where('id', $req->clientId)->first();
        $new = $target_update->totalTarget + $req->target;
        $target_update = DB::table('client_targets')->where('id', $req->clientId)
            ->update(array('totalTarget' => $new));

        session()->flash('success', 'New collector Target added successfully !');

        return Redirect::to('/target/view/' . $data['clientTargetId']);

    }


    public function deleteCollectorTarget($id, $amount, $cid)
    {


        $target_update = DB::table('client_targets')->select('totalTarget')
            ->where('id', $cid)->first();
        $new = $target_update->totalTarget - $amount;
        $target_update = DB::table('client_targets')->where('id', $cid)
            ->update(array('totalTarget' => $new));
        $in = DB::table('collector_targets')->where('id', $id)->delete();
        session()->flash('error', 'Collector Target Deleted !');
        return Redirect::to('/target/view/' . $cid);

    }

    public function editTarget(Request $req)
    {
        $id = $req->id;
        $amount = $req->target;
        $cid = $req->clientId;

        $old = $req->old;

        $target_update = DB::table('client_targets')->select('totalTarget')
            ->where('id', $cid)->first();
        $new = $target_update->totalTarget - $old + $amount;
        $target_update = DB::table('client_targets')->where('id', $cid)
            ->update(array('totalTarget' => $new));
        $in = DB::table('collector_targets')->where('id', $id)->update(array('target' => $amount));
        session()->flash('success', 'details updated !');
        return Redirect::to('/target/view/' . $cid);

    }


    public function viewTarget($id)
    {
//dd($id);

        $target_c = DB::table('client_targets')->where('id', $id)->first();

        $target_collector = DB::table('collector_targets')
            ->where('clientTargetId', $id)->get();
        $c_name = $target_c->client;

        $free_collector = DB::table('batch_datas')->select('collector')
            ->when($c_name, function ($query, $c_name) {
                // if ($c_name != 'null')
                return $query->join('batchs', 'batchs.batch_name', '=', 'batch_datas.batch_name')->where('batchs.client_name', $c_name);

            })->groupBy('collector')
            ->get()->pluck('collector')->toArray();

        $assi_collector = $target_collector->pluck('collector')->toArray();
        $freeToSign = array_diff($free_collector, $assi_collector);

        return view("statusCodeSetting.targetView")->with('clientTarget', $target_c)->with('target_collector', $target_collector)->with('freeToSign', $freeToSign);

    }


}
