<?php

namespace App\Http\Controllers\paymentManagement;

use App\Exports\paymentExport;
use App\Exports\paymentSummary;
use App\Http\Controllers\Controller;
use App\Imports\batchArray;
use App\Imports\paymentImport;
use App\Models\batch_datas;
use App\Models\collectorLog;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\HeadingRowImport;
use mysql_xdevapi\Table;

class paymentController extends Controller
{
    public function imPayment(Request $req)
    {
        $file = $req->file(['file']);
        $headings = (new HeadingRowImport)->toArray($file);
        $count = count($headings[0][0]);

        $data = Excel::toArray(new batchArray, $file);


        $image_name = hexdec(uniqid());
        $ext = strtolower($file->getClientOriginalExtension());
        $image_full_name = $image_name . '.' . $ext;
        $upload_path = 'public/';
        $image_url = $upload_path . $image_full_name;
        $success = $file->move($upload_path, $image_full_name);


//        $profile=DB::table('profiles')->get();
//        $batch_name=DB::table('batchs')->select('batch_name')->get();


//
        session()->put('paymentKey', '0');
//        session()->put('h',$count);
//        session()->put('head',$headings[0][0]);
//        session()->put('profiles',$profile);
//        session()->put('batch_name',$batch_name);


        //$_SESSION['file_data'] = $file;
        return view('paymentManagement.paymentImport')->with('d', $data[0])->with('h', $count)->with('head', $headings[0][0])->with('file', $image_full_name);
    }


    public function storePayment(Request $req)
    {

        $paymentKey = \session()->get('paymentKey');

        if ($paymentKey == '0') {
            $Ref_type=$req->refType;
            $accountNumber = $req->accountNumber;
            $paidAmount = $req->paidAmount;
            $paidBy = $req->paidBy;
            $paidDate = $req->paidDate;
            $paymentType = $req->paymentType;
//dd($Ref_type);
            $uid = strtotime(Carbon::now("Asia/Kuala_Lumpur")->toDateTimeString());

            $data = $req->file;
            $data = "public/" . $data;
            //

            $import = new paymentImport();
            $import->set_name($accountNumber, $paidAmount, $paidBy, $paidDate, $paymentType, $uid,$Ref_type);
            $import->import($data);
            $error = $import->failures();
            File::delete($data);


            session()->put('pay_accountNumber', $accountNumber);
            session()->put('pay_paidAmount', $paidAmount);
            session()->put('pay_paidBy', $paidBy);
            session()->put('pay_paidDate', $paidDate);
            session()->put('pay_paymentType', $paymentType);
            session()->put('pay_uid', $uid);
            session()->put('pay_error', $error);
            session()->put('paymentKey', '1');
            $success = DB::table('confirm_payments')->where('uid', $uid)->get();
            session()->put('pay_success', $success);
            $this->updatePaymentToBatchData($success, $uid);
            session()->flash('success', 'Payment details Uploaded !');
            return view('paymentManagement.paymentSummary')->with('error', $error)->with('success', $success)
                ->with('ac', $accountNumber)->with('pa', $paidAmount)->with('pb', $paidBy)->with('pd', $paidDate)->with('pt', $paymentType);


        } else {
            $accountNumber = session()->get('pay_accountNumber');
            $paidAmount = session()->get('pay_paidAmount');
            $paidBy = session()->get('pay_paidBy');
            $paidDate = session()->get('pay_paidDate');
            $paymentType = session()->get('pay_paymentType');
            $uid = session()->get('pay_uid');
            $error = session()->get('pay_error');

//dd($error);
            $success = DB::table('confirm_payments')->where('uid', $uid)->get();

            session()->flash('success', 'Payment details Uploaded !');

            return view('paymentManagement.paymentSummary')->with('error', $error)->with('success', $success)
                ->with('ac', $accountNumber)->with('pa', $paidAmount)->with('pb', $paidBy)->with('pd', $paidDate)->with('pt', $paymentType);
        }
    }

    public function updatePaymentToBatchData($successfulUpload, $uid)
    {


        foreach ($successfulUpload as $uploadData) {
            //batch data update
            $paidDate = date('Y-m-d H:i:s', strtotime($uploadData->paidDate));
            batch_datas::where('AccountNo', $uploadData->accountNumber)
                ->update([
                    'totalDue' => DB::raw('totalDue-' . $uploadData->paidAmount . ''),
                    'TotalSettlement' => DB::raw('TotalSettlement-' . $uploadData->paidAmount . ''),
                    'LastPaidDate' => $uploadData->paidDate,
                    'LastPaidAmount' => $uploadData->paidAmount,
                ]);


//            collector for the  payment
            $collector = DB::table("collector_logs")->select('collector', 'from', 'to')->
            where('accountNumber', $uploadData->accountNumber)->where('from', '<=', $paidDate)
//                ->where(function($q)use ($paidDate) {
//                    $q->where('to', '=>', $paidDate)
//                        ->orWhere('to', null);
//                })

                ->get();

            $collectorName = null;
            foreach ($collector as $c) {
                if ($c->to == null) {
                    $c->to = date("Y-m-d H:i:s");
                }
                if ($c->to >= $paidDate) {
                    $collectorName = $c->collector;
                }


            }
            if ($collectorName == null) {
                $collectorName = 'NO_Collector';
            }
//dd($collectorName);

            $paymentupdate = DB::table('confirm_payments')->where('accountNumber', $uploadData->accountNumber)->where('uid', $uid)->update(['collector' => $collectorName]);

        }

    }

    public function paymentMethod()
    {

        $success = DB::table('payment_methods')->get();
        return view('paymentManagement.paymentMethod')->with('payment', $success);
    }


    public function registerPaymentMethod(Request $req)
    {

        $a = array();


        $a['paymentMethod'] = $req->paymentMethod;
        $success = DB::table('payment_methods')->insert($a);
        session()->flash('success', 'New Payment method added !');
        return \redirect(url('/paymentMethod'));
    }


    public function payMethod_delete($id)
    {


        $success = DB::table('payment_methods')->where('id', $id)->delete();
        session()->flash('error', 'Payment method Deleted !');
        return \redirect(url('/paymentMethod'));
    }




    /////////////////////////
    ///
    public function paymentHome()
    {


        $batch = DB::table('batchs')->select('batch_name',)->join('clients', 'clients.name', '=', 'batchs.client_name')->where('clients.status', 'Active')
            ->get();

        $client_name = DB::table('clients')->select('name',)->where('status', 'Active')->
        get();

        $collector = DB::table('users')->select('name')->where('role', 'Collector')
            ->get();


        return view('paymentManagement.paymentHome')->with('batch', $batch)->with('collector', $collector)->with('client_name', $client_name);
    }





    /////////////////////////
    ///
    public function search_payment(Request $req)
    {

        $Collector = $req->Collector;
        $BatchNo = $req->BatchNo;
        $client = $req->c_name;
        $accounts = $req->accounts;
        if ($accounts != null)
            $accounts = preg_split("/(;\r\n|;|\r\n)/", $accounts);

        $from = $req->from;
        $to = $req->to;
        session()->put('pay_from', $from);
        session()->put('pay_to', $to);
///dd($from);


        if ($BatchNo != null or $Collector != null or $client != null or $accounts != null) {
            $batch = DB::table('batch_datas')->select('AccountNo')
                ->when($BatchNo, function ($query, $BatchNo) {
                    //if ($BatchNo != 'null')
                    return $query->where('batch_datas.batch_name', $BatchNo);
                })
                ->when($Collector, function ($query, $Collector) {
                    //if ($BatchNo != 'null')
                    return $query->where('batch_datas.collector', $Collector);
                })
                ->when($client, function ($query, $c_name) {
                    // if ($c_name != 'null')
                    return $query->join('batchs', 'batchs.batch_name', '=', 'batch_datas.batch_name')->where('batchs.client_name', $c_name);
                })
                ->when($accounts, function ($query, $accounts) {
                    //if ($BatchNo != 'null')
                    return $query->whereIn('batch_datas.AccountNo', $accounts);
                })
                ->get()->pluck('AccountNo')->toArray();


            // dd($batch);

        } else
            $batch = null;


        if ($batch != null or $from != null or $to != null) {
            $ac = DB::table('confirm_payments')
                ->when($batch, function ($query, $batch) {

                    return $query->whereIn('confirm_payments.accountNumber', $batch);
                })
                ->when($from, function ($query, $from) {
                    $to = \session()->get('pay_to');


                    if ($from != null and $to != null)
                        return $query->whereBetween('confirm_payments.paidDate', [$from, $to]);


                    if ($from != null and $to == null) {
                        return $query->where('confirm_payments.paidDate', '>=', $from);
                    }
                })
                ->when($to, function ($query, $to) {
                    $from = \session()->get('pay_from');

                    if ($to != null and $from == null) {
                        return $query->where('confirm_payments.paidDate', '<=', $to);
                    }
                })
                ->get();


            $paidDataExport = $ac->pluck('accountNumber')->toArray();
            session()->put('paidDataExport', $paidDataExport);


            // return (new paymentExport($ac))->download('invoices.xlsx');


            return view('paymentManagement.viewPayment')->with('ac', $ac);

        }// data found
        else {
            session()->flash('error', 'No Data found with given condition !!!');
            return redirect()
                ->back()
                ->withInput();


        }


    }

/////////////////////////////////////////////

    public function downloadPayment()
    {
        $paidDataExport = session()->get('paidDataExport');


        return (new paymentExport($paidDataExport))->download('PaymentDetails_' . date("Y-m-d") . '.xlsx');
    }


    public function downloadPayment_summary($type)
    {

        if ($type == 'error') {

            $paidDataExport = session()->get('pay_error');
            $accountNumber = session()->get('pay_accountNumber');
            $paidAmount = session()->get('pay_paidAmount');
            $paidBy = session()->get('pay_paidBy');
            $paidDate = session()->get('pay_paidDate');
            $paymentType = session()->get('pay_paymentType');
            $i = 0;
            $summary = array();
            foreach ($paidDataExport as $data) {
                $summary[$i][0] = " " . $data->values()[$accountNumber];
                $summary[$i][1] = $data->values()[$paidAmount];
                $summary[$i][2] = $data->values()[$paidBy];
                $summary[$i][3] = $data->values()[$paidDate];
                $summary[$i][4] = $data->values()[$paymentType];
                $summary[$i][5] = 'Account Not Found';

                $i++;
            }


            $export = new paymentSummary($summary);
            return Excel::download($export, 'errorPayment.xlsx');
        } elseif ($type == 'success') {
            $pay_success = session()->get('pay_success');
            $i = 0;
            $summary = array();
            foreach ($pay_success as $data) {
                $summary[$i][0] = " " . $data->accountNumber;
                $summary[$i][1] = $data->paidAmount;
                $summary[$i][2] = $data->paidBy;
                $summary[$i][3] = $data->paidDate;
                $summary[$i][4] = $data->paymentType;
                $summary[$i][5] = 'Successful';

                $i++;
            }

            $export = new paymentSummary($summary);
            return Excel::download($export, 'SuccessPayment.xlsx');
        }


//dd($summary);

    }


}//
