<?php

namespace App\Http\Controllers\contactManagement;

use App\Http\Controllers\Controller;
use App\Imports\batchArray;
use App\Imports\contactImport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\HeadingRowImport;

class contactManagement extends Controller
{
    public function imContact(Request $req){
        $file= $req->file(['file']);
        $headings = (new HeadingRowImport)->toArray($file);
        $count=count($headings[0][0]) ;

        $data = Excel::toArray(new batchArray, $file);



        $image_name = hexdec(uniqid());
        $ext = strtolower($file->getClientOriginalExtension());
        $image_full_name = $image_name . '.' . $ext;
        $upload_path = 'public/';
        $image_url = $upload_path . $image_full_name;
        $success = $file->move($upload_path, $image_full_name);





        $profile=DB::table('profiles')->get();
        $batch_name=DB::table('batchs')->select('batch_name')->get();


//
//        session()->put('d',$data[0]);
//        session()->put('h',$count);
//        session()->put('head',$headings[0][0]);
//        session()->put('profiles',$profile);
//        session()->put('batch_name',$batch_name);


        //$_SESSION['file_data'] = $file;
        return view('contactManagement.contactImport' )->with('d',$data[0])->with('h',$count)->with('head',$headings[0][0])->with('file',$image_full_name)->with('profiles',$profile)->with('batch_name',$batch_name);
    }




    public function storeContact(Request $req){

        $name=$req->name;
        if($req->aorn =='nric'){
            $nric=$req->nric;
            $AccountNo=null;
            $Type=null;
        }
        else{
            $AccountNo=$req->nric;
            $Type=$req->type;
            $nric=null;
        }

        $address=$req->address;
        $Source=$req->Source;
        $telNumber=$req->telNumber;

        $data= $req->file;
        $data="public/".$data;


        $import = new contactImport();
        $import->set_name($name,$nric,$address,$Source,$telNumber,$AccountNo,$Type);
        $import->import($data);


        File::delete($data);
        session()->flash('success', 'Contact uploaded successfully  !');
        return redirect(url('/contact/home'));
    }




    public function contactSearch(Request $req){

        $bulk = $req->bulk;
        $radio=$req->radio;

        $bulk = preg_split("/(;\r\n|;|\r\n)/", $bulk);
        //dd(var_dump($bulk));

        session()->put('bulkContact', $bulk);
        session()->put('radio', $radio);
        $contact = DB::table('contacts')->whereIn($radio, $bulk)->get();

        return view('contactManagement.contactView')->with('contact', $contact);

   }







   public function contactEdit($id){
       $contact = DB::table('contacts')->where('id', $id)->first();
       return view('contactManagement.contactEdit')->with('contact', $contact);
   }




    public function contactUpdate(Request $req,$id ){
        $a_info=array();
        $a_info['name']=$req->name;
        $a_info['nric']=$req->nric;
       $a_info['address']=$req->address;
       $a_info['Source']=$req->Source;
       $a_info['telNumber']=$req->telNumber;

        $submit = DB::table('contacts')->where('id',$id)->update($a_info);

        $bulk=session()->get('bulkContact');
        $radio = session()->get('radio');

        $contact = DB::table('contacts')->whereIn($radio, $bulk)->get();
        session()->now('success', 'details updated !');
        return view('contactManagement.contactView')->with('contact', $contact);

    }




    public function contactDelete($id){
        $delete=DB::table('contacts')->where('id',$id)->delete();



        $bulk=session()->get('bulkContact');
        $radio = session()->get('radio');

        $contact = DB::table('contacts')->whereIn($radio, $bulk)->get();
        session()->now('error', 'contact Detected !');
        return view('contactManagement.contactView')->with('contact', $contact);



    }








}
