<?php

namespace App\Http\Controllers\client;


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class clientController extends Controller
{
    protected function registerClient(Request $req)
    {
        $this->validate($req, [
            'name' => 'required|max:120',
            'email' => 'required|email|unique:users',
            'tel_no' => 'required|min:11|numeric'

        ]);

        $a_info = array();

        $a_info["name"] = $req->name;
        $a_info["address"] = $req->address;
        $a_info["tel_no"] = $req->tel_no;
        $a_info["email"] = $req->email;
        $a_info["person_incharge1"] = $req->person_incharge1;
        $a_info["person_incharge2"] = $req->person_incharge2;

        $submit = DB::table('clients')->insert($a_info);

        session()->flash('success', 'New Client added successfully !');


        return redirect()->route('viewClient');
    }

///////////////////////////////////////////////////////////////////////////////////
    public function viewClient()
    {
        $client = DB::table('clients')
            ->get();

        return view('clientManagement.viewAllClient', array('user' => Auth::user()))->with('client', $client);
    }


///////////////////////////////////////////////////////////////////////////


    public function deactivateClient($id)
    {
        $status = "Inactive";


        $affected = DB::table('clients')
            ->where('id', $id)
            ->update(['status' => $status]);
        session()->flash('warning', 'Client Deactivated !');
        return redirect()->route('viewClient');

    }

///////////////////////////////////////////////////////////


    public function activateClient($id)
    {
        $status = "Active";


        $affected = DB::table('clients')
            ->where('id', $id)
            ->update(['status' => $status]);
        session()->flash('success', 'Client Activated !');
        return redirect()->route('viewClient');

    }

/////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////

    public function editClient($id)
    {

        $user = DB::table('clients')->where('id', $id)
            ->first();
        return view('clientManagement.editClient', array('user' => Auth::user()))->with('client', $user);
    }

////////////////////////////////////////////////////////////
    public function updateClient(Request $req, $id)
    {
        $a_info = array();

        $a_info["name"] = $req->name;
        $a_info["address"] = $req->address;
        $a_info["tel_no"] = $req->tel_no;
        $a_info["email"] = $req->email;
        $a_info["person_incharge1"] = $req->person_incharge1;
        $a_info["person_incharge2"] = $req->person_incharge2;


        $submit = DB::table('clients')->where('id', $id)->update($a_info);
        echo "<script>";
        echo "alert('details updated');";
        echo "</script>";
        session()->flash('success', 'details updated !');
        return redirect()->route('viewClient')->withInput();
    }


/////////////////////////////////////////////////////////////////


}
