<?php

namespace App\Http\Controllers\batch;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class batchController extends Controller
{

    public function index()
    {
        $client= DB::table('clients')->select('name')
            ->get();


        return view('batchManagement.addBatch')->with('client',$client);
    }


    //////////////////////////////////////////////////////////////////////

    protected function registerBatch(Request $req)
    {$this->validate($req,[
        'batch_name' => 'required|unique:batchs',
        'assign_date'    => 'required|date',
        'valid_till'      => 'date|after_or_equal:assign_date',

    ]);

        $a_info = array();

        $a_info["client_name"] = $req->client_name;
        $a_info["batch_name"] = $req->batch_name;
        $a_info["assign_date"] = $req->assign_date;
        $a_info["valid_till"] = $req->valid_till;



        $submit = DB::table('batchs')->insert($a_info);
        session()->flash('success', 'New Batch added successfully !');
        return redirect()->route('viewBatch');
    }


////////////////////////////////////////////////////////////////////////////
    public function viewBatch()
    {
        $batch=DB::table('batchs')
            ->get();

        return view('batchManagement.viewBatch', array('user' => Auth::user()) )->with('batch',$batch);
    }





///////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////

    public function editBatch($id){

        $batch=DB::table('Batchs')->where('id',$id)
            ->first();
        return view('batchManagement.editBatch', array('user' => Auth::user()) )->with('batch',$batch);
    }

////////////////////////////////////////////////////////////


    public function updateBatch(Request $req,$id)
    {
        $this->validate($req,[

            'assign_date'    => 'required|date',
            'valid_till'      => 'date|after_or_equal:assign_date',

        ]);

        $a_info["assign_date"] = $req->assign_date;
        $a_info["valid_till"] = $req->valid_till;



        $submit = DB::table('batchs')->where('id',$id)->update($a_info);
        echo "<script>";
        echo "alert('details updated');";
        echo "</script>";
        session()->flash('success', 'details updated !');
        return redirect()->route('viewBatch')->withInput();
    }
/////////////////////////////////////////////////////////////////////////
    public function deactivateBatch($id)
    {
        $status = "Inactive";


        $affected = DB::table('batchs')
            ->where('id', $id)
            ->update(['status' => $status]);
        session()->flash('warning', 'Batch Deactivated !');
        return redirect()->route('viewBatch');

    }
///////////////////////////////////////////////////////////



    public function activateBatch($id)
    {
        $status = "Active";


        $affected = DB::table('batchs')
            ->where('id', $id)
            ->update(['status' => $status]);
        session()->flash('success', 'Batch Activated !');
        return redirect()->route('viewBatch');

    }





}
