<?php

namespace App\Http\Controllers\batch;

use App\Exports\searchedAccount;
use App\Http\Controllers\collector\collectorDashbord;
use App\Http\Controllers\Controller;

use App\Http\Controllers\LeaveSetting\Leave;
use App\Models\batch_datas;
use App\Models\collectorLog;
use App\Models\internalNotes;
use App\Models\statusLogs;
use Carbon\Carbon;
use DatePeriod;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Intervention\Image\Facades\Image;
use phpDocumentor\Reflection\Types\Null_;
use DateTime;
use DateInterval;
use function PHPUnit\Framework\isEmpty;

class assignmentManagement extends Controller
{
    public function search_batch()
    {


        $batch = DB::table('batchs')->
        get();
        $collector = DB::table('users')->where('role', 'Collector')
            ->get();
        $code = DB::table('status_code_settings')->select('remark_code', "type")
            ->get();
        $client_name = DB::table('clients')->select('name',)->
        get();
        return view('assignmentManagement.searchBatch')->with('batch', $batch)->with('collector', $collector)->with('code', $code)->with('client_name', $client_name);
    }


    public function searched(Request $req)
    {
        // $start = microtime(true);
        //  dd($req->request);

        $set = $req->set;
        session()->put('set', $set);
//        //leave start
//
//        $leaves=DB::table('leaves')->get();
//        $allLeaves=array();
//        foreach ($leaves as $leave){
//            if($leave->to ==null){
//
//                $a=strtotime($leave->from);
//                $newformat = date('j-n-Y',$a);
//                array_push($allLeaves,$newformat);
//
//            }
//
//            else{
//                $dates=$this->dateSplitter($leave->from,$leave->to);
//                //  dd($leave->to->modify('+1 day'));
//                foreach ($dates as $d){
//
//                    array_push($allLeaves,$d);
//
//                }
//
//
//            }
//        }
//
//        ///leave stop


        $leave = new Leave();

        $allLeaves = $leave->leaves();


        if ($set == '1') {

            $c_name = $req->c_name;
            $BatchNo = $req->BatchNo;
            $Collector = $req->Collector;
            $Name = $req->Name;
            $New_Nric = $req->New_Nric;
            $Old_Nric = $req->Old_Nric;
            $Vehicle_no = $req->Vehicle_no;
            $Status = $req->Status;
            $amount_to = $req->amount_to;
            $amount_from = $req->amount_from;
            session()->put('to', $amount_to);
            session()->put('from', $amount_from);

//            session()->put('c_name', $c_name);
//            session()->put('BatchNo', $BatchNo);
//            session()->put('Collector', $Collector);
//            session()->put('Name', $Name);
//            session()->put('New_Nric', $New_Nric);
//            session()->put('Old_Nric', $Old_Nric);
//            session()->put('Vehicle_no', $Vehicle_no);
//            session()->put('Status', $Status);
            //

            $next_call_from = $req->next_call_from;
            $next_call_to = $req->next_call_to;

            $ptp_call_from = $req->ptp_call_from;
            $ptp_call_to = $req->ptp_call_to;
            $phone = $req->phone;
            session()->put('next_call_from', $next_call_from);
            session()->put('next_call_to', $next_call_to);
            session()->put('ptp_call_from', $ptp_call_from);
            session()->put('ptp_call_to', $ptp_call_to);
            //dd($to=\session()->get('to'));
            $type = $req->type;
            $todayNext = $req->todayNext;

//            if(isset( $req->todayNext)){
//
//                dd($req->todayNext);
//            }
            //  Carbon\Carbon::parse('11/06/1990')->format('d/m/Y')
//dd(Carbon::now("Asia/Kuala_Lumpur")->toDateString());


            if (isset($phone)) {

                $contact = DB::table('contacts')->select('nric')->where('telNumber', $phone)->get()->pluck('nric');


            } else
                $contact = null;


//dd($req->type);
            $batch = DB::table('batch_datas')->select('AccountNo', 'batch_datas.batch_name', 'collector', 'batch_datas.status', 'DebtorName', 'NewNric', 'OldNric', 'CardNo', 'VehicleNo', 'DueDate', 'totalDue')
                ->when($BatchNo, function ($query, $BatchNo) {

                    return $query->where('batch_datas.batch_name', $BatchNo);
                })
                ->when($c_name, function ($query, $c_name) {
                    // if ($c_name != 'null')
                    return $query->join('batchs', 'batchs.batch_name', '=', 'batch_datas.batch_name')->where('batchs.client_name', $c_name);
                })
                ->when($Collector, function ($query, $Collector) {

                    return $query->where('batch_datas.collector', $Collector);
                })
                ->when($Status, function ($query, $Status) {

                    return $query->where('batch_datas.status', $Status);
                })
                ->when($Name, function ($query, $Name) {

                    return $query->where('batch_datas.DebtorName', $Name);
                })
                ->when($New_Nric, function ($query, $New_Nric) {

                    return $query->where('batch_datas.NewNric', $New_Nric);
                })
                ->when($Old_Nric, function ($query, $Old_Nric) {

                    return $query->where('batch_datas.OldNric', $Old_Nric);
                })
                ->when($Vehicle_no, function ($query, $Vehicle_no) {

                    return $query->where('batch_datas.VehicleNo', $Vehicle_no);
                })
                ->when($amount_from, function ($query, $amount_from) {
                    $to = \session()->get('to');


                    if ($amount_from != null and $to != null)
                        return $query->whereBetween('batch_datas.totalDue', [$amount_from, $to]);


                    if ($amount_from != null and $to == null) {
                        return $query->where('batch_datas.totalDue', '>=', $amount_from);
                    }
                })
                ->when($amount_to, function ($query, $amount_to) {
                    $from = \session()->get('from');

                    if ($amount_to != null and $from == null) {
                        return $query->where('batch_datas.totalDue', '<=', $amount_to);
                    }
                })
                ->when($next_call_from, function ($query, $next_call_from) {
                    $to = \session()->get('next_call_to');


                    if ($next_call_from != null and $to != null)
                        return $query->whereBetween('batch_datas.nextCall', [$next_call_from, $to]);


                    if ($next_call_from != null and $to == null) {
                        return $query->where('batch_datas.nextCall', '>=', $next_call_from);
                    }
                })
                ->when($next_call_to, function ($query, $next_call_to) {
                    $from = \session()->get('next_call_from');

                    if ($next_call_to != null and $from == null) {
                        return $query->where('batch_datas.nextCall', '<=', $next_call_to);
                    }
                })
                ->when($ptp_call_from, function ($query, $ptp_call_from) {
                    $to = \session()->get('ptp_call_to');


                    if ($ptp_call_from != null and $to != null)
                        return $query->whereBetween('batch_datas.ptpDate', [$ptp_call_from, $to]);


                    if ($ptp_call_from != null and $to == null) {
                        return $query->where('batch_datas.ptpDate', '>=', $ptp_call_from);
                    }
                })
                ->when($ptp_call_to, function ($query, $ptp_call_to) {
                    $from = \session()->get('ptp_call_from');

                    if ($ptp_call_to != null and $from == null) {
                        return $query->where('batch_datas.ptpDate', '<=', $ptp_call_to);
                    }
                })
                ->when($todayNext, function ($query, $todayNext) {


                    return $query->where('batch_datas.nextCall', '=', Carbon::now("Asia/Kuala_Lumpur")->toDateString());

                })

//                ->when($contact, function ($query, $contact) {
//                    if ($contact != 'null')
//
//                        return $query->whereIn('batch_datas.NewNric', $contact );
//                })
                ->when($contact, function ($query, $contact) {
                    if ($contact != 'null')
                        // dd($contact);
                        return $query->whereIn('batch_datas.OldNric', $contact)->orwhereIn('batch_datas.NewNric', $contact);
                })
                ->when($type, function ($query, $type) {

                    return $query->where('batch_datas.abort', $type);
                })
                ->get();
//dd($batch);
            $collector = DB::table('users')->select("name")->where('role', 'Collector')->where('status', 'Active')->get();
//            $time = microtime(true) - $start;
//            dd($time);


            $account = $batch->pluck('AccountNo')->toArray();

            session()->put('account', $account);
            session()->put('account_type', $type);


            $status = DB::table('status_code_settings')->get();
            session()->now('success', 'Showing data according to searched Filters !');


            $color = new collectorDashbord();
            $color = $color->color($status);
            $note_acc = $batch->pluck('AccountNo')->toArray();
            $note_blink = new collectorDashbord();
            $note_acc = $note_blink->blinkInternalNote($note_acc);
            return view('assignmentManagement.allBatch')->with('batch', $batch)->with('collector', $collector)->with('status', $status)->with('leaves', $allLeaves)->with('color', $color)->with('note_acc', $note_acc);
        } elseif ($set == '2') {

            $bulk = $req->bulk;
            // dd($bulk);
            $bulk = preg_split("/(;\r\n|;|\r\n)/", $bulk);
            // session()->put('bulk', $bulk);
            $batch = DB::table('batch_datas')->whereIn('AccountNo', $bulk)->get();
            $collector = DB::table('users')->select("name")->where('role', 'Collector')->where('status', 'Active')->get();
            $status = DB::table('status_code_settings')->get();


            $account = $batch->pluck('AccountNo')->toArray();

            session()->put('account', $account);
            session()->put('account_type', $req->type);
            session()->now('success', 'Showing data according to searched Filters !');
            $color = new collectorDashbord();
            $color = $color->color($status);
            $note_acc = $batch->pluck('AccountNo')->toArray();
            $note_blink = new collectorDashbord();
            $note_acc = $note_blink->blinkInternalNote($note_acc);
            return view('assignmentManagement.allBatch')->with('batch', $batch)->with('collector', $collector)->with('status', $status)->with('leaves', $allLeaves)->with('color', $color)->with('note_acc', $note_acc);

        }
    }

////////////////


    public function accountChange($ac, $go)
    {
        $account = session()->get('account');
        $current = array_search($ac, $account);
        if ($go == 'next')
            $goto = $current + 1;
        if ($go == 'pre')
            $goto = $current - 1;


        //            $ac+


        if (isset($account[$goto])) {
            session()->flash('success', 'Successful migration to ' . $go . ' Account #');
            return \redirect(url('/account/details/' . $account[$goto]));
        } else {
            if ($go == 'next') {
                $goo = 'NEXT';
                $too = 'PREVIOUS';
            } else {
                $too = 'NEXT';
                $goo = 'PREVIOUS';
            }

            session()->now('error', 'NO MORE ' . $goo . ' ACCOUNT FOUND,YOU MAY GO TO ' . $too . ' ACCOUNT !');
            return redirect()
                ->back()
                ->withInput();


        }


    }


    /////
    public function assignCollector(Request $req)

    {
        $collectors_f = $req->collectors;
        $status_code = $req->status;
        if ($req->selecta == 'all') {
            $ids_f = session()->get('account');
        } else {
            $ids_f = $req->ids;
        }


        $Cstatus = $req->Cstatus;

        $abortRemark = $req->abortRemark;
        if (isset($req->delete_a)) {
            $delete = DB::table('batch_datas')
                ->whereIn('AccountNo', $ids_f)->delete();
            session()->now('error', 'Account details successfully deleted !');
            return redirect()->route('collectorHome');
        } else {


            if ($collectors_f != null) {

                //count the item
                if ($req->selecta == 'all') {
                    $idc = session()->get('account');
                } else {
                    $idc = $req->ids;
                }
                $ids = count($idc);
                $collectors = count($req->collectors);

                //empty array to store divided account amount
                $c = array();
                $each = intdiv($ids, $collectors);

                for ($i = 0; $i < $collectors; $i++) {
                    $c[$i] = $each;
                }//this for will equally divide ignoring leftover

                $left = $ids % $collectors;//if not equally divided

                if ($left != 0) {
                    for ($j = 0; $j < $left; $j++) {
                        $c[$j] += 1;
                    }
                }


                //checking status

                if ($status_code == 'Null' and $Cstatus == null) {
                    // dd($status_code);
                    //for loop
                    for ($m = 0; $m < $collectors; $m++) {
                        $active = array_slice($ids_f, 0, $c[$m]);//get assigned amount for a collector

                        DB::table('batch_datas')
                            ->whereIn('AccountNo', $active)
                            ->update(array('collector' => $collectors_f[$m]));

                        $collectorlog = $this->collectorLog($active, $collectors_f[$m]);//collector log


                        $ids_f = array_slice($ids_f, $c[$m]);//remove  assigned amount for a collector from main array

                    }
                } elseif ($status_code != 'Null' and $Cstatus == null) {
                    //for loop
                    for ($m = 0; $m < $collectors; $m++) {
                        $active = array_slice($ids_f, 0, $c[$m]);//get assigned amount for a collector

                        DB::table('batch_datas')
                            ->whereIn('AccountNo', $active)

                            //                ->update([array('collector' => $collectors_f[$m]),
                            ->update(['collector' => $collectors_f[$m],
                                'status' => $status_code,
                            ]);


                        $collectorlog = $this->collectorLog($active, $collectors_f[$m]);//collector log

                        $ids_f = array_slice($ids_f, $c[$m]);//remove  assigned amount for a collector from main array

                    }
                } elseif ($status_code == 'Null' and $Cstatus != null) {
                    //for loop
                    for ($m = 0; $m < $collectors; $m++) {
                        $active = array_slice($ids_f, 0, $c[$m]);//get assigned amount for a collector

                        DB::table('batch_datas')
                            ->whereIn('AccountNo', $active)

                            //                ->update([array('collector' => $collectors_f[$m]),
                            ->update(['collector' => $collectors_f[$m],
                                'abort' => $Cstatus,
                                'remark' => $abortRemark,
                            ]);


                        $collectorlog = $this->collectorLog($active, $collectors_f[$m]);//collector log

                        $ids_f = array_slice($ids_f, $c[$m]);//remove  assigned amount for a collector from main array

                    }
                } elseif ($status_code != 'Null' and $Cstatus != null) {
                    //for loop
                    for ($m = 0; $m < $collectors; $m++) {
                        $active = array_slice($ids_f, 0, $c[$m]);//get assigned amount for a collector

                        DB::table('batch_datas')
                            ->whereIn('AccountNo', $active)

                            //                ->update([array('collector' => $collectors_f[$m]),
                            ->update(['collector' => $collectors_f[$m],
                                'status' => $status_code,
                                'abort' => $Cstatus,
                                'remark' => $abortRemark,
                            ]);


                        $collectorlog = $this->collectorLog($active, $collectors_f[$m]);//collector log

                        $ids_f = array_slice($ids_f, $c[$m]);//remove  assigned amount for a collector from main array

                    }
                }


            }//if  collector selected

            else {
                if ($collectors_f == null and $Cstatus != null) {
                    DB::table('batch_datas')
                        ->whereIn('AccountNo', $ids_f)
                        ->update(['status' => $status_code,
                            'abort' => $Cstatus,
                            'remark' => $abortRemark,

                        ]);
                } elseif ($collectors_f == null and $Cstatus == null) {
                    DB::table('batch_datas')
                        ->whereIn('AccountNo', $ids_f)
                        ->update(['status' => $status_code,
                        ]);

                }

            }


            if ($collectors_f == null and $Cstatus != null and $status_code == 'Null') {
                DB::table('batch_datas')
                    ->whereIn('AccountNo', $ids_f)
                    ->update(['abort' => $Cstatus,
                        'remark' => $abortRemark,
                    ]);
            }


            //status log

            if ($status_code != 'Null') {
                $log = array();
                $log["status"] = $status_code;
                $log["by"] = auth()->user()->name;
                $log["remark"] = $req->remark;
                if ($req->nextCall != null) {
                    $log["nextCall"] = Carbon::createFromFormat('d/m/Y', $req->nextCall)->format('Y-m-d');
                } else
                    $log["nextCall"] = null;
                if ($req->selecta == 'all') {
                    $idl = session()->get('account');
                } else {
                    $idl = $req->ids;
                }
                $log = $this->statusLog($log, $idl);

            }


            //end status log


            //leave start

            $leaves = DB::table('leaves')->get();
            $allLeaves = array();
            foreach ($leaves as $leave) {
                if ($leave->to == null) {

                    $a = strtotime($leave->from);
                    $newformat = date('j-n-Y', $a);
                    array_push($allLeaves, $newformat);

                } else {

                    $leaveClass = new Leave();


                    $dates = $leaveClass->dateSplitter($leave->from, $leave->to);
                    //  dd($leave->to->modify('+1 day'));
                    foreach ($dates as $d) {

                        array_push($allLeaves, $d);

                    }


                }
            }

            ///leave stop

//        if (\session()->get('set') == '1') {
//            $amount_to = session()->get('to');
//            $amount_from = session()->get('from');
//
//            $c_name = session()->get('c_name');
//            $BatchNo = session()->get('BatchNo');
//            $Collector = session()->get('Collector');
//            $Name = session()->get('Name');
//            $New_Nric = session()->get('New_Nric');
//            $Old_Nric = session()->get('Old_Nric');
//            $Vehicle_no = session()->get('Vehicle_no');
//            $Status = session()->get('Status');
//
//
//
//            $batch = DB::table('batch_datas')->select('AccountNo', 'batch_name', 'collector', 'status', 'DebtorName', 'NewNric', 'OldNric', 'CardNo', 'VehicleNo', 'DueDate', 'totalDue')
//                ->when($BatchNo, function ($query, $BatchNo) {
//                    if ($BatchNo != 'null')
//                        return $query->where('batch_datas.batch_name', $BatchNo);
//                })
//                    ->when($c_name, function ($query, $c_name) {
//                        if ($c_name != 'null')
//                            return $query->join('batchs', 'batchs.batch_name', '=', 'batch_datas.batch_name')->where('client_name', $c_name);
//                    })
//                        ->when($Collector, function ($query, $Collector) {
//                            if ($Collector != 'null')
//                                return $query->where('batch_datas.collector', $Collector);
//                        })
//                            ->when($Status, function ($query, $Status) {
//                                if ($Status != 'null')
//                                    return $query->where('batch_datas.status', $Status);
//                            })
//                                ->when($Name, function ($query, $Name) {
//                                    if ($Name != 'null')
//                                        return $query->where('batch_datas.DebtorName', $Name);
//                                })
//                                    ->when($New_Nric, function ($query, $New_Nric) {
//                                        if ($New_Nric != 'null')
//                                            return $query->where('batch_datas.NewNric', $New_Nric);
//                                    })
//                                        ->when($Old_Nric, function ($query, $Old_Nric) {
//                                            if ($Old_Nric != 'null')
//                                                return $query->where('batch_datas.OldNric', $Old_Nric);
//                                        })
//                                            ->when($Vehicle_no, function ($query, $Vehicle_no) {
//                                                if ($Vehicle_no != 'null')
//                                                    return $query->where('batch_datas.VehicleNo', $Vehicle_no);
//                                                      })
//                                                        ->when($amount_from, function ($query, $amount_from) {
//                                                            $to = \session()->get('to');
//
//
//                                                            if ($amount_from != null and $to != null)
//                                                                return $query->whereBetween('batch_datas.totalDue', [$amount_from, $to]);
//
//
//                                                            if ($amount_from != null and $to == null) {
//                                                                return $query->where('batch_datas.totalDue', '>=', $amount_from);
//                                                            }
//                                                        })
//                                                                ->when($amount_to, function ($query, $amount_to) {
//                                                                    $from = \session()->get('from');
//
//                                                                    if ($amount_to != null and $from == null) {
//                                                                        return $query->where('batch_datas.totalDue', '<=', $amount_to);
//                                                                    }
//                                                                })
//                ->get();
//
//            $collector = DB::table('users')->select("name")->where('role', 'Collector')->where('status', 'Active')->get();
//
//
//            $status = DB::table('status_code_settings')->select("remark_code")->where('status', 'Active')->get();
//
//
//
//
//
//
//            return view('assignmentManagement.allBatch')->with('batch', $batch)->with('collector', $collector)->with('status', $status)->with('leaves',$allLeaves);
//        } elseif (\session()->get('set') == '2') {
//
//
//            $bulk = session()->get('bulk');
//            $batch = DB::table('batch_datas')->whereIn('AccountNo', $bulk)->get();
//            $collector = DB::table('users')->select("name")->where('role', 'Collector')->where('status', 'Active')->get();
//            $status = DB::table('status_code_settings')->select("remark_code")->where('status', 'Active')->get();
//            return view('assignmentManagement.allBatch')->with('batch', $batch)->with('collector', $collector)->with('status', $status)->with('leaves',$allLeaves);
//        }


            $account = session()->get('account');
            $account_type = session()->get('account_type');
//dd($account_type);


            $batch = DB::table('batch_datas')->whereIn('AccountNo', $account)
                ->when($account_type, function ($query, $Status) {

                    return $query->where('abort', $Status);

                })->paginate(1000);
            session()->now('success', 'Task performed successfully !');
            $collector = DB::table('users')->select("name")->where('role', 'Collector')->where('status', 'Active')->get();
            $status = DB::table('status_code_settings')->get();
            $color = new collectorDashbord();
            $color = $color->color($status);
            $note_acc = $batch->pluck('AccountNo')->toArray();
            $note_blink = new collectorDashbord();
            $note_acc = $note_blink->blinkInternalNote($note_acc);
            return view('assignmentManagement.allBatch')->with('batch', $batch)->with('collector', $collector)->with('status', $status)->with('leaves', $allLeaves)->with('color', $color)->with('note_acc', $note_acc);

        }
    }



///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// //////////////////////////////////////////////////


    public function accountDetails($ac)
    {
        $batch = DB::table('batch_datas')->where('AccountNo', $ac)->first();

        if (auth()->user()->role == 'Collector') {
            if (auth()->user()->name != $batch->collector) {
                // return Redirect::back()->withErrors(['msg', 'This account is Not Assigned under Your name , You may ADD/UPDATE internal note only']);

                session()->now('error', 'This account number [' . $ac . '] is Not Assigned under Your name , You may ADD/UPDATE internal note only');


                $account = session()->get('account');
                $account_type = session()->get('account_type');
//dd($account_type);


                $batch = DB::table('batch_datas')->whereIn('AccountNo', $account)
                    ->when($account_type, function ($query, $Status) {

                        return $query->where('abort', $Status);

                    })->paginate(1000);
                $leave = new Leave();

                $allLeaves = $leave->leaves();
                $collector = DB::table('users')->select("name")->where('role', 'Collector')->where('status', 'Active')->get();
                $status = DB::table('status_code_settings')->get();;
                $color = new collectorDashbord();
                $color = $color->color($status);
                $note_acc = $batch->pluck('AccountNo')->toArray();
                $note_blink = new collectorDashbord();
                $note_acc = $note_blink->blinkInternalNote($note_acc);
                return view('assignmentManagement.allBatch')->with('batch', $batch)->with('collector', $collector)->with('status', $status)->with('leaves', $allLeaves)->with('color', $color)->with('note_acc', $note_acc);


            }


        }


        $status = DB::table('status_code_settings')->get();
        $statuslog = DB::table('status_logs')->where('accountNumber', $ac)->orderBy('created_at', 'DESC')->get();
        $collectorlog = DB::table('collector_logs')->where('accountNumber', $ac)->orderBy('from', 'DESC')->get();
        $collectorpaymentlog = DB::table('collector_payment_logs')->where('accountNumber', $ac)->orderBy('id', 'DESC')->get();

        $paymentMethod = DB::table('payment_methods')->get();
        $paymentConfirm = DB::table('confirm_payments')->where('accountNumber', $ac)->get();

//total due

            $totalDue = $batch->totalDue;
            if($totalDue<0){
                $totalDue = 0;
                batch_datas::where('AccountNo',$ac)
                    ->update([
                        'totalDue'=> 0,

                    ]);
            }
            $balance = $batch->TotalSettlement;

        //


        $leaves = DB::table('leaves')->get();
        $allLeaves = array();
        foreach ($leaves as $leave) {
            if ($leave->to == null) {

                $a = strtotime($leave->from);
                $newformat = date('j-n-Y', $a);
                array_push($allLeaves, $newformat);

            } else {
                $leaveClass = new Leave();


                $dates = $leaveClass->dateSplitter($leave->from, $leave->to);
                // $dates=$this->dateSplitter($leave->from,$leave->to);
                //  dd($leave->to->modify('+1 day'));
                foreach ($dates as $d) {

                    array_push($allLeaves, $d);

                }


            }
        }


//dd($allLeaves);

//related accounts

        $batch_client = DB::table('batchs')->where('batch_name', $batch->batch_name)->first();
        $All_batch_name = DB::table('batchs')->select('batch_name')->where('client_name', $batch_client->client_name)->get()->pluck('batch_name');


        $related_accounts = DB::table('batch_datas')->select('AccountNo')->where('NewNric', $batch->NewNric)->whereIn('batch_name', $All_batch_name)->where('AccountNo', '!=', $ac)->get();

        //    total outstanding
        $new_nric=$batch->NewNric;
        $old_nric=$batch->OldNric;
        Session()->put('old_nric', $old_nric);
        $total_outstanding = DB::table('batch_datas')
            ->where(function($query) use ($new_nric){
                $query->where('NewNric', $new_nric);
                $old_nric= Session()->get('old_nric');
                if($old_nric!=null){
                    $query->orWhere('OldNric', $old_nric);
                }


            })
           ->whereIn('batch_name', $All_batch_name)->sum('totalDue');





        //age


//        if($batch->NewNric != null ){
//            $newNric= $batch->NewNric;
////            $newNric='740408065662';
//            $newNric = str_replace('-', '', $newNric);
//            $age= substr($newNric, 0, 6);
//            $yearIndecator= substr($newNric, 8, 1);
//            if($yearIndecator!=0){
//                $age_year='19'.substr($age, 0, 2);
//            }
//            else{
//                $age_year='20'.substr($age, 0, 2);
//            }
//$age_date=$age_year.'-'.substr($age, 2, 2).'-'.substr($age, 4, 2);
//
////            $request->date_of_birth = "2000-10-25";
//            $age = Carbon::parse($age_date)->diff(Carbon::now())->y;
//
//        }

        $age=$this->age($batch->NewNric);

        if( $age == null){
            $age =$batch->Age_c;

        }



//end age
//race
        $name_for_race= $batch->DebtorName;

        if (preg_match('(BINTI|BT|BTE|A/L|AL|BIN)', $name_for_race) === 1) {
            $race='MELAYU';
//            dd($race);
        }
        elseif (preg_match('(A/P|B|AP|ANAK|D/O)', $name_for_race) === 1) {
            $race='INDIA';
        }
        elseif (preg_match('(CINA)', $name_for_race) === 1) {
            $race='CHINESE';
        }
        else{
            $race='OTHERS';
        }





// end rance


//KWSP
        $grantor_age=[];
if($age == 50 || $age== 55){
    $kwsp='EPF-1';
}else{
    $kwsp=null;
}
if (!empty($grantor_age)){
    $kwsp_grantor1='EPF-2';

  //  dd($grantor_age);
}
else{
    $kwsp_grantor1=null;
}


//end KWSP

//reference
        $reference = array();
//        for($j=1; $j<=5; $j++){
//            $reference['RefNric'.$j]=null;
//            $reference['name'.$j]=null;
//            $reference['contactability'.$j]=null;
//            $reference['RefType'.$j]=null;
//            $reference['RefSource'.$j]=null;
//            $reference['ReftelNumber'.$j]=null;
//            $reference['Refaddress'.$j]=null;
//        }


        if ($batch->NewNric != null) {


            $reference['RefNric1'] = $batch->NewNric;
        } else {
            $reference['RefNric1'] = $batch->OldNric;
        }

        $reference['name1'] = $batch->DebtorName;
        $reference['contactability1'] = $batch->contactability;
        $reference['RefType1'] = 'Debtor';
        $reference['RefSource1'] = null;
        $reference['ReftelNumber1'] = null;
        $reference['Refaddress1'] = null;
        $reference['con1'] = 'contactability';

//        if($batch->RefNric!=null){
//            $reference['RefNric2']=$batch->RefNric;
//            $reference['name2']=$batch->RefName;
//            $reference['contactability2']=$batch->refContactability1;
//            $reference['RefType2']=$batch->RefType;
//            $reference['RefSource2']=null;
//            $reference['ReftelNumber2']=null;
//            $reference['Refaddress2']=null;
//        }

        for ($i = 2; $i < 7; $i++) {
            if ($i == 2) {
                if ($batch->RefNric != null) {

                    $reference['RefNric' . $i] = $batch->RefNric;


                    $reference['name' . $i] = $batch->RefName;
                    $reference['contactability' . $i] = $batch->refContactability1;
                    if($batch->RefType=='grantor' || $batch->RefType=='GRANTOR' || $batch->RefType=='Guarantor'){
                        $reference['age' . $i] =$this->age($batch->RefNric);
                        if($reference['age' . $i]==  50 || $reference['age' . $i]== 55){
                            array_push($grantor_age, 1);
                        }
                    }
                    $reference['RefType' . $i] = $batch->RefType;
                    $reference['RefSource' . $i] = null;
                    $reference['ReftelNumber' . $i] = null;
                    $reference['Refaddress' . $i] = null;
                    $reference['con' . $i] = 'refContactability1';
                }
            } else {


                if ($batch->{'RefNric' . ($i - 1)} != null) {

                    $reference['RefNric' . $i] = $batch->{'RefNric' . ($i - 1)};
                    if($batch->RefType=='guarantor' || $batch->RefType=='Guarantor' || $batch->RefType=='GUARANTOR'){
                        $reference['age' . $i] =$this->age($batch->{'RefNric' . ($i - 1)});

                        if($reference['age' . $i]==  50 || $reference['age' . $i]== 55){
                            array_push($grantor_age, 1);
                        }
                    }

                    $reference['name' . $i] = $batch->{'RefName' . ($i - 1)};
                    $reference['contactability' . $i] = $batch->{'refContactability' . ($i - 1)};
                    $reference['RefType' . $i] = $batch->{'RefType' . ($i - 1)};
                    $reference['RefSource' . $i] = null;
                    $reference['ReftelNumber' . $i] = null;
                    $reference['Refaddress' . $i] = null;
                    $reference['con' . $i] = 'refContactability' . ($i - 1);
                }
            }

        }
        $totalRefWithNrid = count($reference) / 8;
//dd($totalRefWithNrid);
        $referencenrid = array();
        for ($j = 1; $j <= $totalRefWithNrid; $j++) {
            array_push($referencenrid, $reference['RefNric' . $j]);
        }

        $ref_contact = DB::table('contacts')->whereIn('nric', $referencenrid)->get();
//$ref_contact_withoutnric=$ref_contact;
        foreach ($ref_contact as $refC) {
            $found = false;
            for ($j = 1; $j <= $totalRefWithNrid && !$found; $j++) {
                if ($refC->nric == $reference['RefNric' . $j]) {

                    $reference['RefSource' . $j] = $refC->Source;
                    $reference['ReftelNumber' . $j] = $refC->telNumber;
                    $reference['Refaddress' . $j] = $refC->address;
                    $found = true;

                    //ok untill nric , now with out nric process
                }

                //$ref_contact->forget($refC);
            }
        }

        if ($totalRefWithNrid < 6) {
            $ref_contact_withoutnric = DB::table('contacts')->Where('AccountNo', $batch->AccountNo)->get();
            if ($ref_contact_withoutnric == '[]') {
                // dd('$ref_contact_withoutnric');
                $ref_contact_withoutnric = null;
            } else {
                // dd($ref_contact_withoutnric);
                //$a=5-$totalRefWithNrid;
                foreach ($ref_contact_withoutnric as $rcw) {
                    $totalRefWithNrid++;
                    $reference['RefNric' . $totalRefWithNrid] = $rcw->nric;
                    $reference['name' . $totalRefWithNrid] = $rcw->name;
                    $reference['contactability' . $totalRefWithNrid] = $rcw->contactability;
                    $reference['RefType' . $totalRefWithNrid] = $rcw->type;
                    $reference['RefSource' . $totalRefWithNrid] = $rcw->Source;
                    $reference['ReftelNumber' . $totalRefWithNrid] = $rcw->telNumber;
                    $reference['Refaddress' . $totalRefWithNrid] = $rcw->address;
                    $reference['con' . $totalRefWithNrid] = null;

                    if ($totalRefWithNrid == 6) {

                        break;
                    }

                }
            }

        } else {
            $ref_contact_withoutnric = null;
        }

        $totalref = count($reference) / 8;
//dd($reference);
        //reference


        $acNote = $related_accounts->pluck('AccountNo')->toArray();
        $acNote[] = $ac;
//

        $note = DB::table('notes')->whereIn('accountNumber', $acNote)->first();
        $mappedBatch = DB::table('mapped_batches')->where('batch_name', $batch->batch_name)->first();
//dd($note);
        return view('assignmentManagement.accountDetails')->with('batch', $batch)->with('status', $status)->with('log', $statuslog)->with('collectorlog', $collectorlog)->with('paymentLog', $collectorpaymentlog)
            ->with('paymentMethod', $paymentMethod)->with('confirmPayment', $paymentConfirm)->with('leaves', $allLeaves)->with('relatedAccounts', $related_accounts)
            ->with('totalDue', $totalDue)->with('balance', $balance)->with('note', $note)->with('batchInfo', $batch_client)->with('mappedBatch', $mappedBatch)
            ->with('reference', $reference)->with('refcount', $totalref)->with('Age',$age)->with('Race',$race)->with('total_outstanding',$total_outstanding)
            ->with('kwsp',$kwsp)->with('kwsp_guarantor',$kwsp_grantor1);
    }
/////////////////////////////////////////////////////////////////////////
///
///
//function dateSplitter($start, $end){
//$dates=array();
//    $period = new DatePeriod(
//        new DateTime($start),
//        new DateInterval('P1D'),
//        new DateTime($end)
//    );
//
//    foreach ($period as $key => $value) {
//        $d=$value->format('j-n-Y');
//        array_push($dates,$d);
//
//    }
//
//    array_push($dates,date('j-n-Y',strtotime($end)));
//return $dates;
//}
///Age calculator

public function age($nric){

    if($nric != null and strlen((string)$nric)==12){

        $newNric= $nric;
//            $newNric='740408065662';
        $newNric = str_replace('-', '', $newNric);
        $age= substr($newNric, 0, 6);
        $yearIndecator= substr($newNric, 8, 1);
        if($yearIndecator!=0){
            $age_year='19'.substr($age, 0, 2);
        }
        else{
            $age_year='20'.substr($age, 0, 2);
        }
        $age_date=$age_year.'-'.substr($age, 2, 2).'-'.substr($age, 4, 2);
//print_r(strlen((string)$nric));
//            $request->date_of_birth = "2000-10-25";
        if(checkdate(substr($age, 2, 2),substr($age, 4, 2),$age_year)){
            $age = Carbon::parse($age_date)->diff(Carbon::now())->y;
            return $age;

        }else{
            return null;
        }

    }
    else{
        return $age=null;
    }
}

////
///
///
    public function updateNote(Request $req, $ac, $batch)
    {


        $a_info["note"] = $req->note;
        $a_info["by"] = $req->by;
//        $a_info["accountNumber"] = $ac;
//        $a_info["batchName"] = $batch;


        $submit = DB::table('notes')->where('accountNumber', $ac)->where('batchName', $batch)->update($a_info);


        session()->flash('success', 'Note updated !');

        return \redirect(url('/account/details/' . $ac));
    }


/////////////////////////////////////////////////////////////////////////
///
///

    public function addNote(Request $req, $ac, $batch)
    {


        $a_info["note"] = $req->note;
        $a_info["by"] = $req->by;
        $a_info["accountNumber"] = $ac;
        $a_info["batchName"] = $batch;


        $submit = DB::table('notes')->where('accountNumber', $ac)->where('batchName', $batch)->insert($a_info);


        session()->flash('success', 'New Note Added !');
        // returnn back to details page
        return \redirect(url('/account/details/' . $ac));
    }


///////////////////////////////////


    public function statusUpdate(Request $req, $ac, $batch)
    {


        if (isset($req->conName)) {
            $con[$req->conName] = $req->conData;
            $contactibility = DB::table('batch_datas')->where('accountNo', $ac)->where('batch_name', $batch)->update($con);
        } else {
            //  dd($req->tel);
            $con2['contactability'] = $req->conData;
            $contactibility = DB::table('contacts')->where('AccountNo', $ac)->where('telNumber', $req->tel)->update($con2);
            // dd($contactibility);
        }


//    $a_info["status"] = $req->status;
//    $submit = DB::table('batch_datas')->where('accountNo',$ac)->where('batch_name',$batch)->update($a_info);
        $log = array();
        $log["status"] = $req->status;
        $log["by"] = $req->by;
        $log["accountNumber"] = $ac;
        $log["batchName"] = $batch;
        $log["remark"] = $req->remark;
        $log["ptpAmount"] = $req->ptpAmount;
        $log["ptpDate"] = $req->ptpDate;
        $log["tel"] = $req->tel;
        $log["to"] = $req->to;

        if ($req->nextCall != null) {
            $log["nextCall"] = Carbon::createFromFormat('d/m/Y', $req->nextCall)->format('Y-m-d');
        } else
            $log["nextCall"] = null;

        $log = $this->statusLog($log, 'null');
        if ($req->status == 'ptp') {
            $a_info = array();
            $a_info["status"] = $req->status;
            //$a_info[$req->conName] = $req->conData;
            $submit = DB::table('batch_datas')->where('accountNo', $ac)->where('batch_name', $batch)->update($a_info);
        }
//        else{
//            $a_info = array();
//            //dd($req->conName);
//            $a_info[$req->conName] = $req->conData;
//            $submit = DB::table('batch_datas')->where('accountNo', $ac)->where('batch_name', $batch)->update($a_info);
//        }

        session()->flash('success', 'Status has been updated !');
        return \redirect(url('/account/details/' . $ac));
    }


    public function accountUpdate(Request $req, $ac, $batch)
    {

        $a_info = array();

        $a_info["by"] = $req->by;

        $a_info["status"] = $req->status;
        $a_info["remark"] = $req->remark;
        $a_info["ptpAmount"] = $req->ptpAmount;
        $a_info["ptpDate"] = $req->ptpDate;
        $goto = $req->goto;


        if ($req->nextCall != null) {
            $a_info["nextCall"] = Carbon::createFromFormat('d/m/Y', $req->nextCall)->format('Y-m-d');
        } else
            $a_info["nextCall"] = null;

        $submit = DB::table('batch_datas')->where('accountNo', $ac)->where('batch_name', $batch)->update($a_info);
        session()->flash('success', 'Account Status has been updated !');
        // return \redirect(url('/account/details/' . $ac));
        return \redirect(url('/account/change/' . $ac . '/' . $goto));


    }




////////////////////////////////////////////////////
///
///

    public function statusLog($data, $bulk)
    {
        if ($bulk == 'null') {
//dd($data['accountNumber']);
            DB::table('status_logs')
                ->where('accountNumber', $data['accountNumber'])
                ->where('now', 'active')
                ->update([
                    'now' => 'deactivated',

                ]);
            statusLogs::create($data);
        } else {
            $i = 0;
            foreach ($bulk as $c) {
                $unique_code2[$i]['accountNumber'] = $c;
                $unique_code2[$i]['by'] = $data['by'];
                $unique_code2[$i]['status'] = $data['status'];
                $unique_code2[$i]['nextCall'] = $data['nextCall'];
                $unique_code2[$i]['remark'] = $data['remark'];
                $unique_code2[$i]['created_at'] = Carbon::now("Asia/Kuala_Lumpur")->toDateTimeString();
                $i++;
            }


            $chunks = array_chunk($unique_code2, 500);
            foreach ($chunks as $chunk) {
                statusLogs::insert($chunk);
            }
        }
    }


    ////////////////////////////////////////////////////////////
    public function collectorLog($account, $collectors)
    {

        DB::table('collector_logs')
            ->whereIn('accountNumber', $account)
            ->where('status', 'active')
            ->update([
                'status' => 'deactivated',
                'to' => Carbon::now("Asia/Kuala_Lumpur")->toDateTimeString(),
                'by' => auth()->user()->name,
            ]);


        //
        $i = 0;
        foreach ($account as $c) {
            $unique_code2[$i]['accountNumber'] = $c;
            $unique_code2[$i]['collector'] = $collectors;
            $unique_code2[$i]['by'] = auth()->user()->name;

            // $unique_code2[$i]['from'] =Carbon::now("Asia/Kuala_Lumpur")->toDateTimeString();
            $i++;
        }


        $chunks = array_chunk($unique_code2, 500);
        foreach ($chunks as $chunk) {
            collectorLog::insert($chunk);
        }
    }//


    public function newPayment(Request $req, $ac, $batch)
    {


        $payment_d = array();


        $payment_d["batch"] = $batch;
        $payment_d["collector"] = $req->by;
        $payment_d["accountNumber"] = $ac;
        $payment_d["paidDate"] = $req->paidDate;
        $payment_d["paidAmount"] = $req->paidAmount;


        $receipt = $req->file('receipt');
        if (isset($receipt)) {
            $filename = $ac . '_' . strtotime(Carbon::now("Asia/Kuala_Lumpur")->toDateTimeString()) . '.' . $receipt->getClientOriginalExtension();
            // Image::make($receipt)->save(public_path('/uploads/receipts/' . $filename));
            $upload_path = public_path('/uploads/receipts/');
            $success = $receipt->move($upload_path, $filename);
            $payment_d["receipt"] = $filename;
        }


        $payment_d["paymentType"] = $req->paymentType;
        // $paidBy =explode( '.', $req->paidBy );//index 0 nric , index 1 name
        //$payment_d["paidByNric"] = $paidBy[0];
        $payment_d["paidByName"] = $req->paidBy;


        $submit = DB::table('collector_payment_logs')->insert($payment_d);

        session()->flash('success', 'New payment has been added !');
        return \redirect(url('/account/details/' . $ac));

    }


    public function downloadAccount()
    {
        // $paidDataExport= session()->get('paidDataExport');
        $account = session()->get('account');

        return (new searchedAccount($account))->download('Accounts_'.date("Y-m-d").'.xlsx');
    }


    public function fetchNote($ac)
    {
        $data = DB::table('internal_notes')->where('accountNo', $ac)
            ->first();
        $leave = new Leave();

        $allLeaves = $leave->leaves();
        $delete = null;

        $user_name = auth()->user()->name;
        $user_role = auth()->user()->role;
        if ($user_role == 'Superuser' or $user_role == 'Admin') {
            $delete = 'ok';
        } else {
            $col_name = DB::table('batch_datas')->select('collector')->where('AccountNo', $ac)->get()->pluck('collector');
            if ($col_name[0] == $user_name) {
                $delete = 'ok';
            }
        }

        return view('assignmentManagement.internalNote')->with('data', $data)->with('ac', $ac)->with('leaves', $allLeaves)->with('delete', $delete);
    }


    public function createOrUpdateNote(Request $req)
    {
        if (!isset($req->back)) {

            $data = array();
            // $data['accountNo']=$req->ac;
            $data['by'] = auth()->user()->name;
            $data['note'] = $req->note;
            $data['actionDate'] = $req->actionDate;

//       $upload=internalNotes::updateOrCreate(['note'=>$req->note,'actionDate'=>$req->actionDate,'by'=>auth()->user()->name],
//['accountNo'=>$req->ac]
//       );

            $instance = internalNotes::where('accountNo', $req->ac);
            //dd($instance);
            if ($instance->count() != 0) {
                // dd('ok');
                $instance->update($data);
            } else {
                $data['accountNo'] = $req->ac;
                $instance = $instance->create($data);
            }

            session()->now('success', 'ADD/UPDATE note performed successfully!');
        }//isset back

        $account = session()->get('account');
        $account_type = session()->get('account_type');
//dd($account_type);


        $batch = DB::table('batch_datas')->whereIn('AccountNo', $account)
            ->when($account_type, function ($query, $Status) {

                return $query->where('abort', $Status);

            })->paginate(1000);


        $leave = new Leave();

        $allLeaves = $leave->leaves();

        $collector = DB::table('users')->select("name")->where('role', 'Collector')->where('status', 'Active')->get();

        $status = DB::table('status_code_settings')->get();

        $color = (new \App\Http\Controllers\collector\collectorDashbord)->color($status);

        $note_acc = $batch->pluck('AccountNo')->toArray();
        $note_blink = new collectorDashbord();
        $note_acc = $note_blink->blinkInternalNote($note_acc);
        return view('assignmentManagement.allBatch')->with('batch', $batch)->with('collector', $collector)->with('status', $status)->with('leaves', $allLeaves)->with('color', $color)->with('note_acc', $note_acc);

        //return view('assignmentManagement.internalNote')->with('data',$data)->with('ac',$ac)->with('leaves',$leave);
    }

    public function deleteNote($ac)
    {
//        $data = DB::table('internal_notes')->where('accountNo', $ac)
//            ->first();
//        $leave = new Leave();
//
//        $allLeaves = $leave->leaves();
        $delete = null;

        $user_name = auth()->user()->name;
        $user_role = auth()->user()->role;
        if ($user_role == 'Superuser' or $user_role == 'Admin') {
            $data = DB::table('internal_notes')->where('accountNo', $ac)
                ->delete();
            $delete = 'ok';
        } else {
            $col_name = DB::table('batch_datas')->select('collector')->where('AccountNo', $ac)->get()->pluck('collector');
            if ($col_name[0] == $user_name) {
                $data = DB::table('internal_notes')->where('accountNo', $ac)
                    ->delete();
                $delete = 'ok';
            }
        }

        if (isset($delete)) {

            $type = 'success';
            $notification = 'Note deleted ';
        } else {
            $type = 'error';
            $notification = 'You are not permitted to delete the Note ';
        }

        return \redirect(url('/backToAllBatch/' . $type . '/' . $notification));
        //return view('assignmentManagement.internalNote')->with('data', $data)->with('ac', $ac)->with('leaves', $allLeaves)->with('delete',$delete);
    }

    public function backToAllBatch($type, $notification)
    {

        $account = session()->get('account');
        $account_type = session()->get('account_type');
//dd($account_type);


        $batch = DB::table('batch_datas')->whereIn('AccountNo', $account)
            ->when($account_type, function ($query, $Status) {

                return $query->where('abort', $Status);

            })->paginate(1000);


        $leave = new Leave();

        $allLeaves = $leave->leaves();

        $collector = DB::table('users')->select("name")->where('role', 'Collector')->where('status', 'Active')->get();

        $status = DB::table('status_code_settings')->get();

        $color = (new \App\Http\Controllers\collector\collectorDashbord)->color($status);
        session()->flash($type, $notification);
        $note_acc = $batch->pluck('AccountNo')->toArray();
        $note_blink = new collectorDashbord();
        $note_acc = $note_blink->blinkInternalNote($note_acc);
        return view('assignmentManagement.allBatch')->with('batch', $batch)->with('collector', $collector)->with('status', $status)->with('leaves', $allLeaves)->with('color', $color)->with('note_acc', $note_acc);

    }

}//the end






