<?php

namespace App\Http\Controllers\LeaveSetting;


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use DateTime;
use DateInterval;
use DatePeriod;

class Leave extends Controller
{
    protected function registerLeave(Request $req)
    {


        $this->validate($req, [
            'from' => 'required|date',
            'to' => 'date|after_or_equal:from',

        ]);
        $a_info = array();

        $a_info["name"] = $req->name;
        $a_info["description"] = $req->description;
        $a_info["from"] = $req->from;
        $a_info["to"] = $req->to;


        $submit = DB::table('leaves')->insert($a_info);
        session()->now('success', 'New Leave added successfully !');
        return redirect()->route('viewLeave');
    }


///////////////////////////////////////////////////////////////////////////////////
    public function viewLeave()
    {
        $leaves = DB::table('leaves')
            ->get();

        return view('leaveManagement.viewAllLeave', array('user' => Auth::user()))->with('leaves', $leaves);
    }


///////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////

    public function editLeave($id)
    {

        $leave = DB::table('Leaves')->where('id', $id)
            ->first();
        return view('leaveManagement.editLeave', array('user' => Auth::user()))->with('leave', $leave);
    }

////////////////////////////////////////////////////////////


    public function updateLeave(Request $req, $id)
    {
        $this->validate($req, [
            'from' => 'required|date',
            'to' => 'date|after_or_equal:from',

        ]);

        $a_info = array();

        $a_info["name"] = $req->name;
        $a_info["description"] = $req->description;
        $a_info["from"] = $req->from;
        $a_info["to"] = $req->to;


        $submit = DB::table('leaves')->where('id', $id)->update($a_info);
        echo "<script>";
        echo "alert('details updated');";
        echo "</script>";
        session()->now('success', 'Leave details updated !');
        return redirect()->route('viewLeave')->withInput();
    }

    public function deleteLeave($id)
    {
        $delete = DB::table('leaves')->where('id', $id)->delete();
        echo "<script>";
        echo "alert('survey details deleted');";
        echo "</script>";
        session()->now('error', 'Leave details deleted !');
        return Redirect()->route('viewLeave')->withInput();

    }


    public function leaves()
    {
        //leave start

        $leaves = DB::table('leaves')->get();
        $allLeaves = array();
        foreach ($leaves as $leave) {
            if ($leave->to == null) {

                $a = strtotime($leave->from);
                $newformat = date('j-n-Y', $a);
                array_push($allLeaves, $newformat);

            } else {
                $dates = $this->dateSplitter($leave->from, $leave->to);
                //  dd($leave->to->modify('+1 day'));
                foreach ($dates as $d) {

                    array_push($allLeaves, $d);

                }


            }
        }

        ///leave stop
        return $allLeaves;
    }


    public function dateSplitter($start, $end)
    {
        $dates = array();
        $period = new DatePeriod(
            new DateTime($start),
            new DateInterval('P1D'),
            new DateTime($end)
        );

        foreach ($period as $key => $value) {
            $d = $value->format('j-n-Y');
            array_push($dates, $d);

        }

        array_push($dates, date('j-n-Y', strtotime($end)));
        return $dates;
    }

}
