<?php

namespace App\Http\Controllers;

use App\Http\Controllers\LeaveSetting\Leave;

use Illuminate\Http\Request;
use Response;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function selectedColour($id)
    {
        $data = DB::table('collector_targets')->where('clientTargetId', $id)->select('id', 'collector')
            ->get();

        return Response::json($data);
    }

    public function index()
    {
        // $d=DB::table('collector_targets')->groupBy('clientTargetId')->get();
        // dd($d);
        $selects = DB::table('client_targets')->select('client', 'id')
            ->where('status', 'Active')
            ->get();
        return view('home')->with('selects', $selects);
    }


    public function target(Request $req)
    {
        $data = array();
        $client = $req->colour;
        $collector = $req->size;
        $role = auth()->user()->role;
//dd($req->method());

        if ($req->method() != 'GET' or $role == 'Collector') {


            $today = date('Y-m-d');


            if ($role == 'Collector') {
                $name = auth()->user()->name;
                $collector = DB::table('collector_targets')
                    ->join('client_targets', 'client_targets.id', '=', 'collector_targets.clientTargetId')
                    ->where('collector', $name)
                    ->where('client_targets.status', 'Active')->first();

                if ($collector != null) {
                    $client = $collector->clientTargetId;
                    $collector_name = explode("~~", $collector->collector);
                    $target_sum = $collector->target;
                } else {
                    dd('No Target Found');
                }
            }


            // dd($target_sum);

            $target = DB::table('client_targets')->where('id', $client)->first();
            if ($role != 'Collector') {
                if ($collector != null) {
                    $collector = DB::table('collector_targets')->whereIn('id', $collector)->get();
                } else {
                    $collector = DB::table('collector_targets')->where('clientTargetId', $client)->get();
                }

                $collector_name = $collector->pluck('collector')->toArray();
                $target_sum = array_sum($collector->pluck('target')->toArray());

            }

//total account worked
            $today_action_to = date("Y-m-d H:i:s", strtotime('+1 day -1 second', strtotime(date('Y-m-d', strtotime($today)))));
            $today_action_from = date("Y-m-d H:i:s", strtotime('-0 day ', strtotime(date('Y-m-d', strtotime($today)))));

            $batches = DB::table('batchs')->select('batch_name')->where('client_name', $target->client)->get()->pluck('batch_name')->toArray();
            $accountWorked = DB::table('status_logs')
                ->select('status_logs.id')
                ->whereIn('status_logs.by', $collector_name)
                ->join('batch_datas', 'batch_datas.AccountNo', '=', 'status_logs.accountNumber')
                ->whereIn('batch_datas.batch_name', $batches)
                ->whereIn('batch_datas.collector', $collector_name)
                ->where('status_logs.now', 'active')
                ->whereBetween('status_logs.created_at', [$today_action_from, $today_action_to])
                ->count();
//dd($today_action_from);

            //end

            $thisWeekMonday = date('Y-m-d', strtotime("monday this week"));
            if ($thisWeekMonday < $target->cycleFrom) {
                $thisWeekMonday = $target->cycleFrom;
            }

            $thisWeekFriday = date('Y-m-d', strtotime("sunday this week"));
            if ($thisWeekFriday > $target->cycleTo) {
                $thisWeekFriday = $target->cycleTo;
            }


            $totalworkablemonth = count($this->workableDay($target->cycleFrom, $target->cycleTo));
            $totalmonthdaytogo = count($this->workableDay($today, $target->cycleTo));
            $totalThisWeekWorkableDay = count($this->workableDay($thisWeekMonday, $thisWeekFriday));
            if ($totalThisWeekWorkableDay == 0)
                $totalThisWeekWorkableDay = 1;
            $ThisWeekWorkableDayToGo = count($this->workableDay($today, $thisWeekFriday));
            if ($ThisWeekWorkableDayToGo == 0)
                $ThisWeekWorkableDayToGo = 1;


            ////////////////
            //$prevWeekcollected amount
            if (date('Y-m-d', strtotime("sunday last week")) > $target->cycleFrom) {
                $action_to = date("Y-m-d H:i:s", strtotime('+1 day , -1 seconds', strtotime(date('Y-m-d', strtotime("sunday last week")))));


//dd($action_to);
                $action_from = date("Y-m-d H:i:s", strtotime('-0 day ', strtotime($target->cycleFrom)));


                $prevWeekcollected = DB::table('collector_payment_logs')
                    ->join('batchs', 'batchs.batch_name', '=', 'collector_payment_logs.batch')->where('batchs.client_name', $target->client)
                    ->whereIn('collector', $collector_name)
                    ->whereBetween('paidDate', [$action_from, $action_to])
                    ->selectRaw('sum(paidAmount)')
                    ->get()->pluck('sum(paidAmount)');
                $prevWeekcollected = $prevWeekcollected[0];
            } else {
                $prevWeekcollected = 0;
            }

            // dd((count($this->workableDay($thisWeekMonday, $target->cycleTo))));
            $targetDayweek = (count($this->workableDay($thisWeekMonday, $target->cycleTo)));
            if ($targetDayweek == 0)
                $targetDayweek = 1;

            $thisweektarget = (($target_sum - $prevWeekcollected) / $targetDayweek) * $totalThisWeekWorkableDay;

            $data['thisweektarget'] = $thisweektarget;
////
///
///
/// todays target
            $action_to = date("Y-m-d H:i:s", strtotime('+1 day', strtotime(date('Y-m-d', strtotime($thisWeekFriday)))));


            $action_from = date("Y-m-d H:i:s", strtotime('-0 day ', strtotime($thisWeekMonday)));

            $collectedThisweek = DB::table('collector_payment_logs')
                ->join('batchs', 'batchs.batch_name', '=', 'collector_payment_logs.batch')->where('batchs.client_name', $target->client)
                ->whereIn('collector', $collector_name)
                ->whereBetween('paidDate', [$action_from, $action_to])
                ->selectRaw('sum(paidAmount)')
                ->get()->pluck('sum(paidAmount)');
            $collectedThisweek = $collectedThisweek[0];

            $balanceThisweek = $thisweektarget - $collectedThisweek;
            $data['balanceThisweek'] = $balanceThisweek;
            $data['collectedThisweek'] = $collectedThisweek;

            //
            $action_to = date("Y-m-d H:i:s", strtotime(date('Y-m-d', strtotime($today))));
            $collectedThisweekUntillYesterday = DB::table('collector_payment_logs')
                ->join('batchs', 'batchs.batch_name', '=', 'collector_payment_logs.batch')->where('batchs.client_name', $target->client)
                ->whereIn('collector', $collector_name)
                ->whereBetween('paidDate', [$action_from, $action_to])
                ->selectRaw('sum(paidAmount)')
                ->get()->pluck('sum(paidAmount)');
            $collectedThisweekUntillYesterday = $collectedThisweekUntillYesterday[0];

            $targetToday = ($thisweektarget - $collectedThisweekUntillYesterday) / $ThisWeekWorkableDayToGo;

            ////collected today
            $action_to = date("Y-m-d H:i:s", strtotime('+1 day', strtotime(date('Y-m-d', strtotime($today)))));


            $action_from = date("Y-m-d H:i:s", strtotime('-0 day ', strtotime($today)));

            $collectedToday = DB::table('collector_payment_logs')
                ->join('batchs', 'batchs.batch_name', '=', 'collector_payment_logs.batch')->where('batchs.client_name', $target->client)
                ->whereIn('collector', $collector_name)
                ->whereBetween('paidDate', [$action_from, $action_to])
                ->selectRaw('sum(paidAmount)')
                ->get()->pluck('sum(paidAmount)');
            $collectedToday = $collectedToday[0];


            $balanceToday = $targetToday - $collectedToday;

            //dd($balanceToday);

            $data['targetToday'] = $targetToday;
            $data['balanceToday'] = $balanceToday;
            $data['collectedToday'] = $collectedToday;
            $data['monthtarget'] = $target_sum;
            $data['monthcollected'] = $collectedThisweek + $prevWeekcollected;
            $data['monthbalance'] = $target_sum - ($collectedThisweek + $prevWeekcollected);
            $data['accountWorked'] = $accountWorked;
            $clientname = $target->client;
        } else {
            $data = null;
            $clientname = null;
            $collector_name = null;
        }
        $selects = DB::table('client_targets')->select('client', 'id')
            ->where('status', 'Active')
            ->get();

        //dd($data);
        return view('assignmentManagement.target')->with('data', $data)->with('selects', $selects)->with('clientname', $clientname)->with('collectors', $collector_name);


        //return view('home')->with('batch',$batch);
    }


    public function leaveDate()
    {


        //leave start

        $leaves = DB::table('leaves')->get();
        $allLeaves = array();
        foreach ($leaves as $leave) {
            if ($leave->to == null) {

                $a = strtotime($leave->from);
                $newformat = date('Y-m-d', $a);
                array_push($allLeaves, $newformat);

            } else {

                $leaveClass = new Leave();


                $dates = $leaveClass->dateSplitter($leave->from, $leave->to);
                //  dd($leave->to->modify('+1 day'));
                foreach ($dates as $d) {
                    $b = strtotime($d);
                    $newformat = date('Y-m-d', $b);
                    array_push($allLeaves, $newformat);

                }


            }
        }

        return $allLeaves;

    }


    public function workableDay($start_date, $end_date)
    {


        $weekfrom = array();
        $weekto = array();
        for ($date = $start_date; $date <= $end_date; $date = date('Y-m-d', strtotime($date . ' + 1 day'))) {

            if (date("w", strtotime($date)) == 0 || date("w", strtotime($date)) == 6) continue;

            $week = date('W', strtotime($date));
            $year = date('Y', strtotime($date));
            $from = date("Y-m-d", strtotime("$date")); //Returns the date of monday in week
            if ($from < $start_date)
                $from = $start_date;
            $to = date("Y-m-d", strtotime("$date-1day + 1 week")); //Returns the date of sunday in week
            if ($to > $end_date) {
                $to = $end_date;
            }
            if ($from <= $to) {
                array_push($weekfrom, $from);
                array_push($weekto, $to);
            }

            $n = count($weekfrom);

//            for ($i = 0; $i < $n; $i++) {
//                echo $weekfrom[$i].'<br>';
//            }}
        }


        $allLeaves = $this->leaveDate();

        $weekfrom = array_diff($weekfrom, $allLeaves);


        return $weekfrom;

    }

}

