<?php

namespace App\Http\Controllers\Auth;


use App\Providers\RouteServiceProvider;
use App\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
//    protected $redirectTo = RouteServiceProvider::HOME;
    protected $redirectTo;
    public function redirectTo()
    {
        $this->redirectTo = '/viewAllUser';
        return $this->redirectTo;

    }
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255','unique:users'],
//            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            //'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }



    public function register(Request $request)
    {
        $this->validator($request->all())->validate();
        event(new Registered($user = $this->create($request->all())));
        return $this->registered($request, $user)
            ?: redirect($this->redirectPath());
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
            $password="ADR123";//default password
        //to increment the id
                            $u_id = DB::table('users')->orderBy('id', 'desc')->pluck("login_name")->first();

                            //$u_id=substr("$u_id", 2, -2);
                            $u_id=++$u_id;//end
        session()->flash('success', 'New User added successfully !');
//        if($data['role'] !='Collector' or $data['role'] !='Team_Leader'){
//            $data['team']=null;
//            $data['manager']=null;
//            dd($data['role']);
//            dd($data['manager']);
//        }
//        elseif ($data['role']=='Team_Leader'){
//            $data['team']=null;
//        }


           // $u_id="ADR001";
        // uncomment the line above to enter the 1st user
        return User::create([
            'name' => $data['name'],
            'login_name' => $u_id,
//            'email' => $data['email'],
            'role' => $data['role'],
            'manager' => $data['manager'],
            'team' => $data['team'],
            'password' => Hash::make($password),


        ]);




    }
}
