<?php

namespace App\Exports;

use App\Models\batch_datas;
use App\Models\confirmPayment;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Cell\DefaultValueBinder;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class searchedAccount extends DefaultValueBinder implements FromQuery, WithHeadings,ShouldAutoSize,
//   WithColumnFormatting
    WithCustomValueBinder
{

    use Exportable;

    /**
     * @var int
     */
    private $year = array();

    public function headings(): array
    {
        return [
            'SN',
            'ClientRefNo',
            'accountNumber',
            'batch_name',
            'collector',
            'status',
            'DebtorName',
            'NewNric',
            'OldNric',
            'CardNo',
            'VehicleNo',
            'DueDate',
            'totalDue',
            'created_at',


        ];
    }

    public function __construct(array $year)
    {
        $this->year = $year;
        //dd($year);

    }


    public function query()
    {
        return batch_datas::query()->select('id', 'ClientRefNo', 'AccountNo', 'batch_name',
            'collector',
            'status',
            'DebtorName',
            'NewNric',
            'OldNric',
            'CardNo',
            'VehicleNo',
            'DueDate',
            'totalDue', 'created_at')->whereIn('AccountNo', $this->year);
    }

//    public function bindValue(Cell $cell, $value)
//    {
//        // TODO: Implement bindValue() method.
//    }
//    public function columnFormats(): array
//    {
//        return [
//
//            'C' => '#0',
//        ];
//    }

    /**
     * @throws \PhpOffice\PhpSpreadsheet\Exception
     */
    public function bindValue(Cell $cell, $value)
    {

            if (is_numeric($value)) {
                $cell->setValueExplicit($value, DataType::TYPE_STRING2);

                return true;
            }

            // else return default behavior
            return parent::bindValue($cell, $value);
        }

}
