<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Cell\DefaultValueBinder;

class paymentSummary extends DefaultValueBinder implements FromArray ,WithHeadings,ShouldAutoSize
{
    protected $summaryData;
    public function __construct(array $summaryData)
    {
        $this->summaryData = $summaryData;
    }


    /**
    * @return array
     */
    public function array(): array
    {
        return $this->summaryData;
    }

    public function bindValue(Cell $cell, $value)
    {

        if (is_numeric($value)) {
            $cell->setValueExplicit($value, DataType::TYPE_STRING2);

            return true;
        }

        // else return default behavior
        return parent::bindValue($cell, $value);
    }

    public function headings(): array
    {
        return [

            'accountNumber',
            'amount',
            'by',
            'date',
            'Type',
            'Status'


        ];
    }
}
