<?php

namespace App\Exports;

use App\Models\confirmPayment;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Cell\DefaultValueBinder;

class paymentExport extends DefaultValueBinder implements FromQuery, WithHeadings,ShouldAutoSize,WithCustomValueBinder
{



    use Exportable;

    /**
     * @var int
     */
    private $year=array();
    public function headings(): array
    {
        return [
            'SN',
            'accountNumber',
            'paidBy',
            'paidDate',
            'paidAmount',
            'paymentType',
            'created_at',
        ];
    }

    public function __construct(array $year)
    {
        $this->year = $year;
    }

    public function query()
    {
        return confirmPayment::query()->select('id', 'accountNumber', 'paidBy', 'paidDate', 'paidAmount','paymentType', 'created_at')->whereIn('accountNumber', $this->year);
    }



    /**
     * @throws \PhpOffice\PhpSpreadsheet\Exception
     */
    public function bindValue(Cell $cell, $value)
    {

        if (is_numeric($value)) {
            $cell->setValueExplicit($value, DataType::TYPE_STRING2);

            return true;
        }

        // else return default behavior
        return parent::bindValue($cell, $value);
    }
}
